/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageSelectBankAccount {
    final BankReference account;

    public MessageSelectBankAccount(BankReference account) {
        this.account = account;
    }

    public static void encode(MessageSelectBankAccount message, FriendlyByteBuf buffer) {
        message.account.encode(buffer);
    }

    public static MessageSelectBankAccount decode(FriendlyByteBuf buffer) {
        return new MessageSelectBankAccount(BankReference.decode(buffer));
    }

    public static void handle(MessageSelectBankAccount message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                BankSaveData.SetSelectedBankAccount((Player)player, message.account);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

