/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferResponse;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankTransferTeam {
    long teamID;
    CoinValue amount;

    public MessageBankTransferTeam(long teamID, CoinValue amount) {
        this.teamID = teamID;
        this.amount = amount;
    }

    public static void encode(MessageBankTransferTeam message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.teamID);
        message.amount.encode(buffer);
    }

    public static MessageBankTransferTeam decode(FriendlyByteBuf buffer) {
        return new MessageBankTransferTeam(buffer.readLong(), CoinValue.decode(buffer));
    }

    public static void handle(MessageBankTransferTeam message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BankReference destination;
            IBankAccountAdvancedMenu menu;
            MutableComponent response;
            AbstractContainerMenu patt1604$temp;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (patt1604$temp = player.f_36096_) instanceof IBankAccountAdvancedMenu && (response = BankAccount.TransferCoins(menu = (IBankAccountAdvancedMenu)patt1604$temp, message.amount, destination = TeamBankReference.of(message.teamID))) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageBankTransferResponse(response));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

