/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferResponse;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankTransferPlayer {
    String playerName;
    CoinValue amount;

    public MessageBankTransferPlayer(String playerName, CoinValue amount) {
        this.playerName = playerName;
        this.amount = amount;
    }

    public static void encode(MessageBankTransferPlayer message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.playerName);
        message.amount.encode(buffer);
    }

    public static MessageBankTransferPlayer decode(FriendlyByteBuf buffer) {
        return new MessageBankTransferPlayer(buffer.m_130277_(), CoinValue.decode(buffer));
    }

    public static void handle(MessageBankTransferPlayer message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BankReference destination;
            IBankAccountAdvancedMenu menu;
            MutableComponent response;
            AbstractContainerMenu patt1719$temp;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (patt1719$temp = player.f_36096_) instanceof IBankAccountAdvancedMenu && (response = BankAccount.TransferCoins(menu = (IBankAccountAdvancedMenu)patt1719$temp, message.amount, destination = PlayerBankReference.of(PlayerReference.of(false, message.playerName)))) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageBankTransferResponse(response));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

