/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageBankInteraction {
    boolean isDeposit;
    CoinValue amount;

    public MessageBankInteraction(boolean isDeposit, CoinValue amount) {
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    public static void encode(MessageBankInteraction message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.isDeposit);
        message.amount.encode(buffer);
    }

    public static MessageBankInteraction decode(FriendlyByteBuf buffer) {
        return new MessageBankInteraction(buffer.readBoolean(), CoinValue.decode(buffer));
    }

    public static void handle(MessageBankInteraction message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            AbstractContainerMenu patt1296$temp;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (patt1296$temp = player.f_36096_) instanceof IBankAccountMenu) {
                IBankAccountMenu menu = (IBankAccountMenu)patt1296$temp;
                if (message.isDeposit) {
                    BankAccount.DepositCoins(menu, message.amount);
                } else {
                    BankAccount.WithdrawCoins(menu, message.amount);
                }
                menu.onDepositOrWithdraw();
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

