/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.blockentity.AuctionStandBlockEntity;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SMessageSyncAuctionStandDisplay {
    private final List<ItemStack> items;

    public SMessageSyncAuctionStandDisplay(List<ItemStack> items) {
        this.items = InventoryUtil.copyList(items);
    }

    public static void encode(SMessageSyncAuctionStandDisplay message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.items.size());
        for (ItemStack item : message.items) {
            buffer.m_130055_(item);
        }
    }

    public static SMessageSyncAuctionStandDisplay decode(FriendlyByteBuf buffer) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            items.add(buffer.m_130267_());
        }
        return new SMessageSyncAuctionStandDisplay(items);
    }

    public static void handle(SMessageSyncAuctionStandDisplay message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> AuctionStandBlockEntity.syncItemsFromServer(message.items));
        supplier.get().setPacketHandled(true);
    }
}

