/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageSubmitBid {
    final long auctionHouseID;
    final int tradeIndex;
    final CoinValue bidAmount;

    public MessageSubmitBid(long auctionHouseID, int tradeIndex, CoinValue bidAmount) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    public static void encode(MessageSubmitBid message, FriendlyByteBuf buffer) {
        buffer.writeLong(message.auctionHouseID);
        buffer.writeInt(message.tradeIndex);
        message.bidAmount.encode(buffer);
    }

    public static MessageSubmitBid decode(FriendlyByteBuf buffer) {
        return new MessageSubmitBid(buffer.readLong(), buffer.readInt(), CoinValue.decode(buffer));
    }

    public static void handle(MessageSubmitBid message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            AbstractContainerMenu patt1571$temp;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (patt1571$temp = player.f_36096_) instanceof TraderMenu) {
                TraderMenu menu = (TraderMenu)patt1571$temp;
                TraderData data = TraderSaveData.GetTrader(false, message.auctionHouseID);
                if (data instanceof AuctionHouseTrader) {
                    AuctionHouseTrader ah = (AuctionHouseTrader)data;
                    ah.makeBid((Player)player, menu, message.tradeIndex, message.bidAmount);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

