/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client;

import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class LCLanguageProvider
extends LanguageProvider {
    protected final String modid;
    protected final String locale;

    public LCLanguageProvider(PackOutput output) {
        this(output, "lightmanscurrency", "en_us_temp");
    }

    public LCLanguageProvider(PackOutput output, String locale) {
        this(output, "lightmanscurrency", locale);
    }

    protected LCLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.modid = modid;
        this.locale = locale;
    }

    protected void addTranslations() {
        this.addWoodenBlocks(ModBlocks.SHELF, "%s Shelf", WoodType::isModded);
        this.addWoodenBlocks(ModBlocks.CARD_DISPLAY, "%s Card Display", WoodType::isModded);
        this.addWoodenBlocks(ModBlocks.BOOKSHELF_TRADER, "%s Bookshelf Trader", WoodType::isModded);
        this.addWoodenBlocks(ModBlocks.AUCTION_STAND, "%s Auction Stand", WoodType::isModded);
    }

    protected void addWoodenItems(@Nonnull RegistryObjectBundle<? extends Item, WoodType> item, @Nonnull String format, @Nonnull Predicate<WoodType> generate) {
        item.forEach((woodType, i) -> {
            if (generate.test((WoodType)woodType)) {
                this.addItem((Supplier)i, String.format(format, woodType.displayName));
            }
        });
    }

    protected void addWoodenBlocks(@Nonnull RegistryObjectBundle<? extends Block, WoodType> block, @Nonnull String format, @Nonnull Predicate<WoodType> generate) {
        block.forEach((woodType, b) -> {
            if (generate.test((WoodType)woodType)) {
                this.addBlock((Supplier)b, String.format(format, woodType.displayName));
            }
        });
    }
}

