/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.TickableCoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CoinChestUpgradeData {
    public static final CoinChestUpgradeData NULL = new CoinChestUpgradeData(ItemStack.f_41583_, new CoinChestUpgrade(){

        @Override
        public void HandleMenuMessage(CoinChestMenu menu, CoinChestUpgradeData data, LazyPacketData message) {
        }

        @Override
        public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        }
    }, -1, () -> {});
    public final int slot;
    private final boolean ticks;
    private int tickTimer = 0;
    private final ItemStack stack;
    public final CoinChestUpgrade upgrade;
    private final Runnable onChange;

    public Item getItem() {
        return this.stack.m_41720_();
    }

    private CoinChestUpgradeData(ItemStack stack, CoinChestUpgrade upgrade, int slot, Runnable onChange) {
        this.stack = stack;
        this.upgrade = upgrade;
        this.slot = slot;
        this.onChange = onChange;
        CoinChestUpgrade coinChestUpgrade = this.upgrade;
        if (coinChestUpgrade instanceof TickableCoinChestUpgrade) {
            TickableCoinChestUpgrade tickable = (TickableCoinChestUpgrade)coinChestUpgrade;
            this.ticks = true;
            this.tickTimer = tickable.getTickFrequency();
        } else {
            this.ticks = false;
        }
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean notNull() {
        return !this.isNull();
    }

    public void copyRelevantData(CoinChestUpgradeData other) {
        if (other.upgrade == this.upgrade) {
            this.tickTimer = other.tickTimer;
        }
    }

    @Nonnull
    public CompoundTag getItemTag() {
        return this.stack.m_41784_();
    }

    public void setItemTag(CompoundTag tag) {
        this.stack.m_41751_(tag);
        this.onChange.run();
    }

    @Nonnull
    public UpgradeType.UpgradeData getUpgradeData() {
        return UpgradeItem.getUpgradeData(this.stack);
    }

    @Nonnull
    public static CoinChestUpgradeData forItem(ItemStack stack, int slot, Runnable onChange) {
        UpgradeItem item;
        Object object = stack.m_41720_();
        if (object instanceof UpgradeItem && (object = (item = (UpgradeItem)object).getUpgradeType()) instanceof CoinChestUpgrade) {
            CoinChestUpgrade upgrade = (CoinChestUpgrade)object;
            return new CoinChestUpgradeData(stack, upgrade, slot, onChange);
        }
        return NULL;
    }

    public void tick(CoinChestBlockEntity be) {
        CoinChestUpgrade coinChestUpgrade;
        if (this.ticks && (coinChestUpgrade = this.upgrade) instanceof TickableCoinChestUpgrade) {
            TickableCoinChestUpgrade tickable = (TickableCoinChestUpgrade)coinChestUpgrade;
            if (--this.tickTimer <= 0) {
                this.tickTimer = tickable.getTickFrequency();
                try {
                    tickable.OnServerTick(be, this);
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error ticking a Tickable CoinChestUpgrade", t);
                }
            }
        }
    }
}

