/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public class CoinChestBankUpgrade
extends CoinChestUpgrade {
    @Override
    public void HandleMenuMessage(CoinChestMenu menu, CoinChestUpgradeData data, LazyPacketData message) {
        if (message.contains("SetBankAccount")) {
            BankReference account = BankReference.load(message.getNBT("SetBankAccount")).flagAsClient(menu.be.isClient());
            this.setBankAccount(data, account);
        }
        if (message.contains("ClearBankAccount")) {
            this.setBankAccount(data, null);
        }
        if (message.contains("SetIsDeposit")) {
            this.setShouldDeposit(data, message.getBoolean("SetIsDeposit"));
        }
    }

    @Override
    public void OnStorageChanged(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        this.ExecuteBankInteraction(be, data);
    }

    @Override
    public void OnEquip(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        this.ExecuteBankInteraction(be, data);
    }

    public boolean getShouldDeposit(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("IsDeposit")) {
            return compound.m_128471_("IsDeposit");
        }
        return true;
    }

    public void setShouldDeposit(CoinChestUpgradeData data, boolean newValue) {
        CompoundTag compound = data.getItemTag();
        compound.m_128379_("IsDeposit", newValue);
        data.setItemTag(compound);
    }

    @Nullable
    public BankReference getBankAccount(boolean isClient, CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("BankAccount")) {
            return BankReference.load(compound.m_128469_("BankAccount")).flagAsClient(isClient);
        }
        return null;
    }

    public void setBankAccount(CoinChestUpgradeData data, BankReference newValue) {
        CompoundTag compound = data.getItemTag();
        if (newValue == null) {
            compound.m_128473_("BankAccount");
        } else {
            compound.m_128365_("BankAccount", (Tag)newValue.save());
        }
        data.setItemTag(compound);
    }

    public CoinValue getTargetAmount(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("TargetAmount")) {
            return CoinValue.safeLoad(compound, "TargetAmount");
        }
        return CoinValue.EMPTY;
    }

    public void setTargetAmount(CoinChestUpgradeData data, CoinValue newValue) {
        CompoundTag compound = data.getItemTag();
        compound.m_128365_("TargetAmount", (Tag)newValue.save());
        data.setItemTag(compound);
    }

    public void ExecuteBankInteraction(CoinChestBlockEntity be, CoinChestUpgradeData data) {
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
    }

    @Override
    public List<Component> getTooltip(UpgradeType.UpgradeData data) {
        return Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.exchange", new Object[0])});
    }

    @Override
    public boolean clearDataFromStack(CompoundTag itemTag) {
        return this.clearTags(itemTag, "IsDeposit", "BankAccount", "TargetAmount");
    }
}

