/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProductComparisonResult {
    private final boolean sameProduct;
    private final boolean sameNBT;
    private final int quantityDifference;

    public boolean Identical() {
        return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
    }

    public boolean SameProductType() {
        return this.sameProduct;
    }

    public boolean SameProductNBT() {
        return this.sameNBT;
    }

    public boolean SameProductQuantity() {
        return this.quantityDifference == 0;
    }

    public int ProductQuantityDifference() {
        return this.quantityDifference;
    }

    private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        this.sameProduct = sameProduct;
        this.sameNBT = sameNBT;
        this.quantityDifference = quantityDifference;
    }

    public static ProductComparisonResult CompareItem(ItemStack original, ItemStack query) {
        boolean isItemEqual;
        boolean bl = isItemEqual = original.m_41720_() == query.m_41720_();
        boolean isTagEqual = original.m_41783_() != null ? original.m_41783_().equals((Object)query.m_41783_()) : query.m_41783_() == null;
        int quantityDifference = original.m_41613_() - query.m_41613_();
        return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CreateRaw(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        return new ProductComparisonResult(sameProduct, sameNBT, quantityDifference);
    }

    public static List<ProductComparisonResult> CompareTwoItems(ItemStack original1, ItemStack original2, ItemStack query1, ItemStack query2) {
        boolean flipMatch;
        ArrayList<ProductComparisonResult> results = new ArrayList<ProductComparisonResult>();
        boolean bl = flipMatch = original1.m_41720_() == query2.m_41720_() && original2.m_41720_() == query1.m_41720_() && original1.m_41720_() != original2.m_41720_() && query1.m_41720_() != query2.m_41720_();
        if (flipMatch) {
            results.add(ProductComparisonResult.CompareItem(original1, query2));
            results.add(ProductComparisonResult.CompareItem(original2, query1));
        } else {
            results.add(ProductComparisonResult.CompareItem(original1, query1));
            results.add(ProductComparisonResult.CompareItem(original2, query2));
        }
        return results;
    }

    public static ProductComparisonResult CompareFluid(FluidStack original, FluidStack query) {
        boolean isFluidEqual;
        boolean bl = isFluidEqual = original.getFluid() == query.getFluid();
        boolean isTagEqual = original.getTag() != null ? original.getTag().equals((Object)query.getTag()) : query.getTag() == null;
        int quantityDifference = original.getAmount() - query.getAmount();
        return new ProductComparisonResult(isFluidEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CompareEnergy(int original, int query) {
        return new ProductComparisonResult(true, true, original - query);
    }
}

