/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata.client;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public abstract class TradeRenderManager<T extends TradeData> {
    public final T trade;

    protected TradeRenderManager(T trade) {
        this.trade = trade;
    }

    public abstract int tradeButtonWidth(TradeContext var1);

    public abstract LazyOptional<ScreenPosition> arrowPosition(TradeContext var1);

    public ScreenPosition alertPosition(TradeContext context) {
        return (ScreenPosition)this.arrowPosition(context).orElseGet(() -> ScreenPosition.ZERO);
    }

    public abstract TradeButton.DisplayData inputDisplayArea(TradeContext var1);

    public abstract List<TradeButton.DisplayEntry> getInputDisplays(TradeContext var1);

    public abstract TradeButton.DisplayData outputDisplayArea(TradeContext var1);

    public abstract List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext var1);

    public final List<AlertData> getAlertData(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<AlertData> alerts = new ArrayList<AlertData>();
        this.addTradeRuleAlertData(alerts, context);
        if (context.getTrader().exceedsAcceptableTaxRate()) {
            alerts.add(AlertData.error(EasyText.translatable("tooltip.lightmanscurrency.tax_limit", new Object[0])));
        }
        this.getAdditionalAlertData(context, alerts);
        return alerts;
    }

    private void addTradeRuleAlertData(List<AlertData> alerts, TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            TradeEvent.PreTradeEvent pte = context.getTrader().runPreTradeEvent(context.getPlayerReference(), (TradeData)this.trade);
            alerts.addAll(pte.getAlertInfo());
        }
    }

    protected abstract void getAdditionalAlertData(TradeContext var1, List<AlertData> var2);

    @Deprecated(since="2.1.2.2")
    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, int mouseX, int mouseY, TradeContext context) {
    }

    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, TradeContext context) {
        this.renderAdditional(button, gui, gui.mousePos.x, gui.mousePos.y, context);
    }

    public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        return null;
    }
}

