/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.terminal.filters;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.ArrayList;
import java.util.List;

public abstract class TraderSearchFilter {
    private static final List<TraderSearchFilter> REGISTERED_FILTERS = new ArrayList<TraderSearchFilter>();

    public static void addFilter(TraderSearchFilter filter) {
        if (filter != null) {
            REGISTERED_FILTERS.add(filter);
        }
    }

    public static boolean CheckFilters(TraderData data, String searchText) {
        for (TraderSearchFilter filter : REGISTERED_FILTERS) {
            try {
                if (!filter.filter(data, searchText)) continue;
                return true;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error filtering traders: ", t);
            }
        }
        return false;
    }

    public static List<TraderData> FilterTraders(List<TraderData> data, String searchText) {
        if (searchText.isBlank()) {
            return data;
        }
        ArrayList<TraderData> results = new ArrayList<TraderData>();
        for (TraderData trader : data) {
            if (!TraderSearchFilter.CheckFilters(trader, searchText)) continue;
            results.add(trader);
        }
        return results;
    }

    public abstract boolean filter(TraderData var1, String var2);
}

