/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachinePriceTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.trade_data.SlotMachineTrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SlotMachineTraderData
extends TraderData
implements TraderItemStorage.ITraderItemFilter {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "slot_machine_trader");
    private CoinValue price = CoinValue.EMPTY;
    private List<ItemStack> lastReward = new ArrayList<ItemStack>();
    private final List<SlotMachineEntry> entries = Lists.newArrayList((Object[])new SlotMachineEntry[]{SlotMachineEntry.create()});
    private boolean entriesChanged = false;
    private final TraderItemStorage storage = new TraderItemStorage(this);
    private final ImmutableList<SlotMachineTrade> trade = ImmutableList.of((Object)new SlotMachineTrade(this));

    public final CoinValue getPrice() {
        return this.price;
    }

    public void setPrice(CoinValue newValue) {
        this.price = newValue;
        this.markPriceDirty();
    }

    public final boolean isPriceValid() {
        return this.price.isValid();
    }

    public List<ItemStack> getLastRewards() {
        return ImmutableList.copyOf(this.lastReward);
    }

    public final List<SlotMachineEntry> getAllEntries() {
        return new ArrayList<SlotMachineEntry>(this.entries);
    }

    public final List<SlotMachineEntry> getValidEntries() {
        return this.entries.stream().filter(SlotMachineEntry::isValid).toList();
    }

    public boolean areEntriesChanged() {
        return this.entriesChanged;
    }

    public void clearEntriesChangedCache() {
        this.entriesChanged = false;
    }

    public void addEntry() {
        if (this.entries.size() >= 100) {
            return;
        }
        this.entries.add(SlotMachineEntry.create());
        this.markEntriesDirty();
    }

    public void removeEntry(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.entries.size()) {
            return;
        }
        this.entries.remove(entryIndex);
        this.markEntriesDirty();
    }

    public final int getTotalWeight() {
        int weight = 0;
        for (SlotMachineEntry entry : this.getValidEntries()) {
            weight += entry.getWeight();
        }
        return weight;
    }

    @Nullable
    public final SlotMachineEntry getRandomizedEntry(TradeContext context) {
        Level level;
        if (context.hasPlayer()) {
            level = context.getPlayer().m_9236_();
        } else {
            try {
                level = LightmansCurrency.PROXY.safeGetDummyLevel();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Could not get a valid level from the trade's context or the proxy. Will have to use Java randomizer");
                return this.getRandomizedEntry(new Random().nextInt(this.getTotalWeight()) + 1);
            }
        }
        return this.getRandomizedEntry(level.f_46441_.m_188503_(this.getTotalWeight()) + 1);
    }

    private SlotMachineEntry getRandomizedEntry(int rand) {
        for (SlotMachineEntry entry : this.getValidEntries()) {
            if ((rand -= entry.getWeight()) > 0) continue;
            return entry;
        }
        return null;
    }

    @Nonnull
    public final List<Component> getSlotMachineInfo() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!this.hasValidTrade()) {
            tooltips.add((Component)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.undefined", new Object[0]).m_130940_(ChatFormatting.RED));
            return tooltips;
        }
        if (!this.hasStock()) {
            tooltips.add((Component)EasyText.translatable("tooltip.lightmanscurrency.outofstock", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        return tooltips;
    }

    public String getOdds(int weight) {
        DecimalFormat df = new DecimalFormat();
        double odds = (double)weight / (double)this.getTotalWeight() * 100.0;
        df.setMaximumFractionDigits(odds < 1.0 ? 2 : 0);
        return df.format(odds);
    }

    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    public SlotMachineTraderData() {
        super(TYPE);
    }

    public SlotMachineTraderData(Level level, BlockPos pos) {
        super(TYPE, level, pos);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER_ALT;
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return type == UpgradeType.ITEM_CAPACITY;
    }

    @Override
    public int getTradeCount() {
        return 1;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.hasStock() ? 1 : 0;
    }

    public boolean hasStock() {
        if (!this.hasValidTrade()) {
            return false;
        }
        if (this.isCreative()) {
            return true;
        }
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isValid() || entry.hasStock(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidTrade() {
        return this.entries.stream().anyMatch(SlotMachineEntry::isValid) && this.isPriceValid();
    }

    @Override
    protected void saveTrades(CompoundTag compound) {
    }

    @Override
    protected MenuProvider getTraderMenuProvider(@Nonnull MenuValidator validator) {
        return new SlotMachineMenuProvider(this.getID(), validator);
    }

    public final void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    public final void markLastRewardDirty() {
        this.markDirty(this::saveLastRewards);
    }

    public final void markEntriesDirty() {
        this.markDirty(this::saveEntries);
    }

    public final void markPriceDirty() {
        this.markDirty(this::savePrice);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        this.saveStorage(compound);
        this.saveLastRewards(compound);
        this.saveEntries(compound);
        this.savePrice(compound);
    }

    protected final void saveStorage(CompoundTag compound) {
        this.storage.save(compound, "Storage");
    }

    protected final void saveLastRewards(CompoundTag compound) {
        ListTag itemList = new ListTag();
        for (ItemStack reward : this.lastReward) {
            if (reward.m_41619_()) continue;
            itemList.add((Object)reward.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("LastReward", (Tag)itemList);
    }

    protected final void saveEntries(CompoundTag compound) {
        ListTag list = new ListTag();
        for (SlotMachineEntry entry : this.entries) {
            list.add((Object)entry.save());
        }
        compound.m_128365_("Entries", (Tag)list);
    }

    protected final void savePrice(CompoundTag compound) {
        compound.m_128365_("Price", (Tag)this.price.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        int i;
        if (compound.m_128441_("Storage")) {
            this.storage.load(compound, "Storage");
        }
        if (compound.m_128441_("LastReward")) {
            this.lastReward.clear();
            ListTag itemList = compound.m_128437_("LastReward", 10);
            for (i = 0; i < itemList.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
                if (stack.m_41619_()) continue;
                this.lastReward.add(stack);
            }
        }
        if (compound.m_128441_("Entries")) {
            this.entries.clear();
            ListTag list = compound.m_128437_("Entries", 10);
            for (i = 0; i < list.size(); ++i) {
                this.entries.add(SlotMachineEntry.load(list.m_128728_(i)));
            }
            this.entriesChanged = true;
        }
        if (compound.m_128441_("Price")) {
            this.price = CoinValue.safeLoad(compound, "Price");
        }
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        json.add("Price", (JsonElement)this.price.toJson());
        JsonArray entryList = new JsonArray();
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isValid()) continue;
            entryList.add((JsonElement)entry.toJson());
        }
        json.add("Entries", (JsonElement)entryList);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Price")) {
            throw new RuntimeException("Slot Machine Trader has no 'Price' entry!");
        }
        this.price = CoinValue.Parse(json.get("Price"));
        this.entries.clear();
        if (json.has("Entries")) {
            JsonArray entryList = new JsonArray();
            for (int i = 0; i < entryList.size(); ++i) {
                try {
                    this.entries.add(SlotMachineEntry.parse(entryList.get(i).getAsJsonObject()));
                    continue;
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error parsing Slot Machine Trader Entry #" + (i + 1), t);
                }
            }
            if (this.entries.size() == 0) {
                throw new RuntimeException("Slot Machine Trader had no valid Entries!");
            }
        } else {
            throw new RuntimeException("Slot Machine Trader has no 'Entries' entry!");
        }
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound) {
        this.saveLastRewards(compound);
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("LastReward")) {
            this.lastReward = new ArrayList<ItemStack>();
            ListTag itemList = compound.m_128437_("LastReward", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
                if (stack.m_41619_()) continue;
                this.lastReward.add(stack);
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
        results.addAll(this.storage.getSplitContents());
    }

    @Nonnull
    public List<SlotMachineTrade> getTradeData() {
        return this.trade;
    }

    @Override
    @Nullable
    public SlotMachineTrade getTrade(int tradeIndex) {
        return (SlotMachineTrade)this.trade.get(0);
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!this.hasValidTrade()) {
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        SlotMachineTrade trade = (SlotMachineTrade)this.trade.get(0);
        if (trade == null) {
            LightmansCurrency.LogError("Slot Machine somehow doesn't have a valid trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (!this.hasStock()) {
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        SlotMachineEntry loot = this.getRandomizedEntry(context);
        if (loot == null) {
            LightmansCurrency.LogError("Slot Machine encountered an error randomizing the loot.");
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (!loot.CanGiveToCustomer(context)) {
            return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        if (context.getPayment(price)) {
            if (!loot.GiveToCustomer(this, context)) {
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.lastReward = loot.getDisplayItems();
            this.markLastRewardDirty();
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                taxesPaid = this.addStoredMoney(price, true);
                if (!this.hasStock()) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), -1));
                }
            }
            this.pushNotification(SlotMachineTradeNotification.create(loot, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(0, new SlotMachineEntryTab(menu));
        menu.setTab(1, new SlotMachinePriceTab(menu));
        menu.setTab(2, new SlotMachineStorageTab(menu));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isItemRelevant(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    private record SlotMachineMenuProvider(long traderID, @Nonnull MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new SlotMachineMenu(windowID, inventory, this.traderID, this.validator);
        }
    }
}

