/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class SlotMachineEntry {
    public static final int ITEM_LIMIT = 4;
    public final List<ItemStack> items;
    private int weight;

    public void TryAddItem(ItemStack item) {
        if (this.items.size() >= 4 || item.m_41619_()) {
            return;
        }
        this.items.add(item);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int newWeight) {
        this.weight = Math.max(1, newWeight);
    }

    private SlotMachineEntry(List<ItemStack> items, int weight) {
        this.items = items;
        this.setWeight(weight);
    }

    public boolean isValid() {
        return this.items.size() > 0 && this.weight > 0;
    }

    public boolean isMoney() {
        return this.items.size() > 0 && this.items.stream().allMatch(i -> MoneyUtil.isCoin(i, false));
    }

    public CoinValue getMoneyValue() {
        return this.isMoney() ? MoneyUtil.getCoinValue(this.items) : CoinValue.EMPTY;
    }

    public void validateItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).m_41619_()) continue;
            this.items.remove(i--);
        }
    }

    public List<ItemStack> getDisplayItems() {
        if (this.isMoney()) {
            return MoneyUtil.getCoinsOfValue(this.getMoneyValue());
        }
        return InventoryUtil.copyList(this.items);
    }

    public boolean CanGiveToCustomer(TradeContext context) {
        if (this.isMoney()) {
            return context.hasPaymentMethod();
        }
        return context.canFitItems(this.items);
    }

    public boolean GiveToCustomer(SlotMachineTraderData trader, TradeContext context) {
        if (this.hasStock(trader)) {
            if (this.isMoney()) {
                CoinValue reward = this.getMoneyValue();
                if (!context.givePayment(reward)) {
                    return false;
                }
                if (!trader.isCreative()) {
                    trader.removeStoredMoney(reward, false);
                }
            } else {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (context.putItem(this.items.get(i).m_41777_())) continue;
                    for (int x = 0; x < i; ++x) {
                        context.collectItem(this.items.get(i).m_41777_());
                    }
                    return false;
                }
                if (!trader.isCreative()) {
                    for (ItemStack i : this.items) {
                        trader.getStorage().removeItem(i);
                    }
                    trader.markStorageDirty();
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasStock(SlotMachineTraderData trader) {
        if (trader.isCreative()) {
            return true;
        }
        if (this.isMoney()) {
            return trader.getStoredMoney().getValueNumber() >= this.getMoneyValue().getValueNumber();
        }
        for (ItemStack item : InventoryUtil.combineQueryItems(this.items)) {
            if (trader.getStorage().hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean isItemRelevant(ItemStack item) {
        if (this.isMoney()) {
            return false;
        }
        return this.items.stream().anyMatch(i -> InventoryUtil.ItemMatches(i, item));
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Items", (Tag)itemList);
        compound.m_128405_("Weight", this.weight);
        return compound;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray itemList = new JsonArray();
        for (ItemStack item : this.items) {
            itemList.add((JsonElement)FileUtil.convertItemStack(item));
        }
        json.add("Items", (JsonElement)itemList);
        json.addProperty("Weight", (Number)this.weight);
        return json;
    }

    public static SlotMachineEntry create() {
        return new SlotMachineEntry(new ArrayList<ItemStack>(), 1);
    }

    public static SlotMachineEntry load(CompoundTag compound) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (compound.m_128441_("Items")) {
            ListTag itemList = compound.m_128437_("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }
        if (compound.m_128441_("Weight")) {
            return new SlotMachineEntry(items, compound.m_128451_("Weight"));
        }
        return new SlotMachineEntry(items, 1);
    }

    public static SlotMachineEntry parse(JsonObject json) throws Exception {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (json.has("Items")) {
            JsonArray itemList = json.getAsJsonArray("Items");
            for (int i = 0; i < itemList.size(); ++i) {
                try {
                    ItemStack stack = FileUtil.parseItemStack(itemList.get(i).getAsJsonObject());
                    if (stack.m_41619_()) {
                        throw new RuntimeException("Cannot add an empty item to a Slot Machine Entry!");
                    }
                    items.add(stack);
                    continue;
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error parsing Slot Machine Entry item #" + (i + 1), t);
                }
            }
            if (items.size() == 0) {
                throw new RuntimeException("Slot Machie Entry has no valid items!");
            }
        } else {
            throw new RuntimeException("Slot Machine Entry has no 'Items' entry!");
        }
        int weight = 1;
        if (json.has("Weight")) {
            weight = json.get("Weight").getAsInt();
        } else {
            LightmansCurrency.LogWarning("Slot Machine Entry has no 'Weight' entry! Will default to a weight of 1.");
        }
        return new SlotMachineEntry(items, weight);
    }
}

