/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerWhitelistTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerWhitelist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "whitelist");
    List<PlayerReference> whitelistedPlayers = new ArrayList<PlayerReference>();

    public ImmutableList<PlayerReference> getWhitelistedPlayers() {
        return ImmutableList.copyOf(this.whitelistedPlayers);
    }

    public PlayerWhitelist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (!this.isWhitelisted(event.getPlayerReference())) {
            event.addDenial(Component.m_237115_((String)"traderule.lightmanscurrency.whitelist.denial"));
        } else {
            event.addHelpful(Component.m_237115_((String)"traderule.lightmanscurrency.whitelist.allowed"));
        }
    }

    public boolean isWhitelisted(PlayerReference player) {
        for (PlayerReference whitelistedPlayer : this.whitelistedPlayers) {
            if (!whitelistedPlayer.is(player)) continue;
            return true;
        }
        return false;
    }

    public boolean addToWhitelist(Player player) {
        PlayerReference pr = PlayerReference.of(player);
        if (!this.isWhitelisted(pr)) {
            this.whitelistedPlayers.add(pr);
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (PlayerReference whitelistedPlayer : this.whitelistedPlayers) {
            playerNameList.add((Object)whitelistedPlayer.save());
        }
        compound.m_128365_("WhitelistedPlayers", (Tag)playerNameList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("WhitelistedPlayers", 9)) {
            this.whitelistedPlayers.clear();
            ListTag playerList = compound.m_128437_("WhitelistedPlayers", 10);
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.m_128728_(i));
                if (reference == null) continue;
                this.whitelistedPlayers.add(reference);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        boolean add = updateInfo.m_128471_("Add");
        String name = updateInfo.m_128461_("Name");
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (add && !this.isWhitelisted(player)) {
            this.whitelistedPlayers.add(player);
        } else if (!add && this.isWhitelisted(player)) {
            PlayerReference.removeFromList(this.whitelistedPlayers, player);
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag compound = new CompoundTag();
        this.saveAdditional(compound);
        return compound;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        this.loadAdditional(data);
    }

    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_WHITELIST;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerWhitelistTab(parent);
    }
}

