/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerDiscountTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDiscounts
extends PriceTweakingTradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "discount_list");
    List<PlayerReference> playerList = new ArrayList<PlayerReference>();
    int discount = 10;

    public ImmutableList<PlayerReference> getPlayerList() {
        return ImmutableList.copyOf(this.playerList);
    }

    public int getDiscount() {
        return this.discount;
    }

    public void setDiscount(int discount) {
        this.discount = MathUtil.clamp(discount, 0, 100);
    }

    public PlayerDiscounts() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.discount_list.info.sale", (Object[])new Object[]{this.discount}));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(Component.m_237110_((String)"traderule.lightmanscurrency.discount_list.info.purchase", (Object[])new Object[]{this.discount}));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.isOnList(event.getPlayerReference())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.giveDiscount(this.discount);
                    break;
                }
                case PURCHASE: {
                    event.hikePrice(this.discount);
                    break;
                }
            }
        }
    }

    public boolean isOnList(PlayerReference player) {
        for (PlayerReference playerReference : this.playerList) {
            if (!playerReference.is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (PlayerReference playerReference : this.playerList) {
            playerNameList.add((Object)playerReference.save());
        }
        compound.m_128365_("Players", (Tag)playerNameList);
        compound.m_128405_("discount", this.discount);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray playerList = new JsonArray();
        for (PlayerReference playerReference : this.playerList) {
            playerList.add((JsonElement)playerReference.saveAsJson());
        }
        json.add("Players", (JsonElement)playerList);
        json.addProperty("discounrd", (Number)this.discount);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Players", 9)) {
            this.playerList.clear();
            ListTag playerNameList = compound.m_128437_("Players", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                PlayerReference reference = PlayerReference.load(thisCompound);
                if (reference != null) {
                    this.playerList.add(reference);
                    continue;
                }
                if (!thisCompound.m_128425_("name", 8) || (reference = PlayerReference.of(false, thisCompound.m_128461_("name"))) == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Players")) {
            this.playerList.clear();
            JsonArray playerList = json.get("Players").getAsJsonArray();
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.get(i));
                if (reference == null || this.isOnList(reference)) continue;
                this.playerList.add(reference);
            }
        }
        if (json.has("discount")) {
            this.discount = json.get("discount").getAsInt();
        }
    }

    @Override
    protected void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Discount")) {
            this.discount = updateInfo.m_128451_("Discount");
        } else {
            boolean add = updateInfo.m_128471_("Add");
            String name = updateInfo.m_128461_("Name");
            PlayerReference player = PlayerReference.of(false, name);
            if (add && !this.isOnList(player)) {
                this.playerList.add(player);
            } else if (!add && this.isOnList(player)) {
                PlayerReference.removeFromList(this.playerList, player);
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_DISCOUNT_LIST;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerDiscountTab(parent);
    }
}

