/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerBlacklistTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerBlacklist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "blacklist");
    List<PlayerReference> bannedPlayers = new ArrayList<PlayerReference>();

    public ImmutableList<PlayerReference> getBannedPlayers() {
        return ImmutableList.copyOf(this.bannedPlayers);
    }

    public PlayerBlacklist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isBlacklisted(event.getPlayerReference())) {
            event.addDenial(Component.m_237115_((String)"traderule.lightmanscurrency.blacklist.denial"));
        }
    }

    public boolean isBlacklisted(PlayerReference player) {
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            if (!bannedPlayer.is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            playerNameList.add((Object)bannedPlayer.save());
        }
        compound.m_128365_("BannedPlayers", (Tag)playerNameList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray blacklist = new JsonArray();
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            blacklist.add((JsonElement)bannedPlayer.saveAsJson());
        }
        json.add("BannedPlayers", (JsonElement)blacklist);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("BannedPlayers", 9)) {
            this.bannedPlayers.clear();
            ListTag playerList = compound.m_128437_("BannedPlayers", 10);
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.m_128728_(i));
                if (reference == null) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        boolean add = updateInfo.m_128471_("Add");
        String name = updateInfo.m_128461_("Name");
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (add && !this.isBlacklisted(player)) {
            this.bannedPlayers.add(player);
        } else if (!add && this.isBlacklisted(player)) {
            PlayerReference.removeFromList(this.bannedPlayers, player);
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("BannedPlayers")) {
            this.bannedPlayers.clear();
            JsonArray blacklist = json.get("BannedPlayers").getAsJsonArray();
            for (int i = 0; i < blacklist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)blacklist.get(i).getAsJsonObject());
                if (reference == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_BLACKLIST;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerBlacklistTab(parent);
    }
}

