/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRule {
    public final ResourceLocation type;
    private ITradeRuleHost host = null;
    private boolean isActive = false;
    static final Map<String, Supplier<TradeRule>> registeredDeserializers = new HashMap<String, Supplier<TradeRule>>();

    public static MutableComponent nameOfType(ResourceLocation ruleType) {
        return EasyText.translatable("traderule." + ruleType.m_135827_() + "." + ruleType.m_135815_(), new Object[0]);
    }

    public final MutableComponent getName() {
        return TradeRule.nameOfType(this.type);
    }

    public boolean isActive() {
        return this.canActivate(this.host) && this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    protected boolean allowHost(@Nonnull ITradeRuleHost host) {
        if (this.onlyAllowOnTraders() && !host.isTrader()) {
            return false;
        }
        return !this.onlyAllowOnTrades() || host.isTrade();
    }

    public boolean canActivate() {
        return this.canActivate(this.host);
    }

    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        return this.allowHost(host);
    }

    protected boolean onlyAllowOnTraders() {
        return false;
    }

    protected boolean onlyAllowOnTrades() {
        return false;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected TradeRule(ResourceLocation type) {
        this.type = type;
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Type", this.type.toString());
        compound.m_128379_("Active", this.isActive);
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void load(CompoundTag compound) {
        this.isActive = compound.m_128471_("Active");
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(CompoundTag var1);

    public abstract JsonObject saveToJson(JsonObject var1);

    public abstract void loadFromJson(JsonObject var1);

    public abstract CompoundTag savePersistentData();

    public abstract void loadPersistentData(CompoundTag var1);

    public final void receiveUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("SetActive")) {
            this.isActive = updateInfo.m_128471_("SetActive");
        }
        this.handleUpdateMessage(updateInfo);
    }

    protected abstract void handleUpdateMessage(CompoundTag var1);

    public static CompoundTag saveRules(CompoundTag compound, List<TradeRule> rules, String tag) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            ruleData.add((Object)rule.save());
        }
        compound.m_128365_(tag, (Tag)ruleData);
        return compound;
    }

    public static boolean savePersistentData(CompoundTag compound, List<TradeRule> rules, String tag) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            CompoundTag thisRuleData = rule.savePersistentData();
            if (thisRuleData == null) continue;
            thisRuleData.m_128359_("Type", rule.type.toString());
            ruleData.add((Object)thisRuleData);
        }
        if (ruleData.size() == 0) {
            return false;
        }
        compound.m_128365_(tag, (Tag)ruleData);
        return true;
    }

    public static JsonArray saveRulesToJson(List<TradeRule> rules) {
        JsonArray ruleData = new JsonArray();
        for (TradeRule rule : rules) {
            JsonObject thisRuleData;
            if (!rule.isActive || (thisRuleData = rule.saveToJson(new JsonObject())) == null) continue;
            thisRuleData.addProperty("Type", rule.type.toString());
            ruleData.add((JsonElement)thisRuleData);
        }
        return ruleData;
    }

    @Deprecated(since="2.1.1.0")
    public static List<TradeRule> loadRules(CompoundTag compound, String tag) {
        return TradeRule.loadRules(compound, tag, null);
    }

    public static List<TradeRule> loadRules(CompoundTag compound, String tag, ITradeRuleHost host) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.m_128425_(tag, 9)) {
            ListTag ruleData = compound.m_128437_(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.m_128728_(i);
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                if (thisRule == null) continue;
                rules.add(thisRule);
                if (host == null) continue;
                thisRule.host = host;
            }
        }
        return rules;
    }

    public static void loadPersistentData(CompoundTag compound, List<TradeRule> tradeRules, String tag) {
        if (compound.m_128425_(tag, 9)) {
            ListTag ruleData = compound.m_128437_(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.m_128728_(i);
                boolean query = true;
                for (int r = 0; query && r < tradeRules.size(); ++r) {
                    if (!tradeRules.get((int)r).type.toString().contentEquals(thisRuleData.m_128461_("Type"))) continue;
                    tradeRules.get(r).loadPersistentData(thisRuleData);
                    query = false;
                }
            }
        }
    }

    @Deprecated(since="2.1.1.3")
    public static List<TradeRule> Parse(JsonArray tradeRuleData) {
        return TradeRule.Parse(tradeRuleData, null);
    }

    public static List<TradeRule> Parse(JsonArray tradeRuleData, ITradeRuleHost host) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        for (int i = 0; i < tradeRuleData.size(); ++i) {
            try {
                JsonObject thisRuleData = tradeRuleData.get(i).getAsJsonObject();
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                thisRule.host = host;
                rules.add(thisRule);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Trade Rule at index " + i + ".", t);
            }
        }
        return rules;
    }

    public static boolean ValidateTradeRuleList(@Nonnull List<TradeRule> rules, @Nonnull ITradeRuleHost host) {
        boolean changed = false;
        for (Supplier<TradeRule> ruleSource : registeredDeserializers.values()) {
            TradeRule rule = (TradeRule)ruleSource.get();
            if (rule == null || !host.allowTradeRule(rule) || !rule.allowHost(host) || TradeRule.HasTradeRule(rules, rule.type)) continue;
            rules.add(rule);
            rule.host = host;
            changed = true;
        }
        return changed;
    }

    public static boolean ValidateTradeRuleActiveStates(@Nonnull List<TradeRule> rules) {
        boolean changed = false;
        for (TradeRule rule : rules) {
            if (!rule.isActive || rule.canActivate()) continue;
            rule.isActive = false;
            changed = true;
        }
        return changed;
    }

    public static boolean HasTradeRule(List<TradeRule> rules, ResourceLocation type) {
        return TradeRule.GetTradeRule(rules, type) != null;
    }

    public static TradeRule GetTradeRule(List<TradeRule> rules, ResourceLocation type) {
        for (TradeRule rule : rules) {
            if (!rule.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public abstract TradeRulesClientSubTab createTab(TradeRulesClientTab<?> var1);

    public static void RegisterDeserializer(ResourceLocation type, Supplier<TradeRule> deserializer) {
        TradeRule.RegisterDeserializer(type, deserializer, false);
    }

    public static void RegisterDeserializer(ResourceLocation type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        TradeRule.RegisterDeserializer(type.toString(), deserializer, suppressDebugMessage);
    }

    private static void RegisterDeserializer(String type, Supplier<TradeRule> deserializer, boolean suppressDebugMessage) {
        if (registeredDeserializers.containsKey(type)) {
            LightmansCurrency.LogWarning("A trade rule deserializer of type '" + type + "' has already been registered.");
            return;
        }
        registeredDeserializers.put(type, deserializer);
        if (!suppressDebugMessage) {
            LightmansCurrency.LogInfo("Registered trade rule deserializer of type " + type);
        }
    }

    public static TradeRule CreateRule(ResourceLocation ruleType) {
        String thisType = ruleType.toString();
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                data.set(rule);
            }
        });
        if (data.get() != null) {
            return (TradeRule)data.get();
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(CompoundTag compound) {
        String thisType;
        String string = thisType = compound.m_128441_("Type") ? compound.m_128461_("Type") : compound.m_128461_("type");
        if (registeredDeserializers.containsKey(thisType)) {
            try {
                TradeRule rule = (TradeRule)registeredDeserializers.get(thisType).get();
                rule.load(compound);
                return rule;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error deserializing trade rule:", t);
            }
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(JsonObject json) throws Exception {
        String thisType = json.get("Type").getAsString();
        if (registeredDeserializers.containsKey(thisType)) {
            TradeRule rule = (TradeRule)registeredDeserializers.get(thisType).get();
            rule.loadFromJson(json);
            rule.setActive(true);
            return rule;
        }
        throw new Exception("Could not find a deserializer of type '" + thisType + "'.");
    }

    public static TradeRule getRule(ResourceLocation type, List<TradeRule> rules) {
        for (TradeRule rule : rules) {
            if (!rule.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    public static CompoundTag CreateRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Create", true);
        return tag;
    }

    public static CompoundTag RemoveRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Remove", true);
        return tag;
    }

    public static boolean isCreateMessage(CompoundTag tag) {
        return tag.m_128441_("Create") && tag.m_128471_("Create");
    }

    public static boolean isRemoveMessage(CompoundTag tag) {
        return tag.m_128441_("Remove") && tag.m_128471_("Remove");
    }
}

