/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.tickets.TicketSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.client.PaygateTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaygateTradeData
extends TradeData {
    int duration = 1;
    long ticketID = Long.MIN_VALUE;
    int ticketColor = 0xFFFFFF;
    boolean storeTicketStubs = false;

    public PaygateTradeData() {
        super(true);
    }

    public int getDuration() {
        return Math.max(this.duration, 1);
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 1);
    }

    public int getTicketColor() {
        return this.ticketColor;
    }

    public boolean isTicketTrade() {
        return this.ticketID >= -1L;
    }

    public long getTicketID() {
        return this.ticketID;
    }

    public void setTicket(ItemStack ticket) {
        this.ticketID = TicketItem.GetTicketID(ticket);
        this.ticketColor = TicketItem.GetTicketColor(ticket);
        this.validateRuleStates();
    }

    public boolean shouldStoreTicketStubs() {
        return this.storeTicketStubs;
    }

    public void setStoreTicketStubs(boolean value) {
        this.storeTicketStubs = value;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.SALE;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isTicketTrade()) {
            return context.hasTicket(this.ticketID) || context.hasPass(this.ticketID);
        }
        return context.hasFunds(this.cost);
    }

    @Override
    public boolean isValid() {
        return this.getDuration() >= 1 && (this.isTicketTrade() || super.isValid());
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data) {
        PaygateTradeData.saveAllData(nbt, data, "Trades");
    }

    public static void saveAllData(CompoundTag nbt, List<PaygateTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (PaygateTradeData datum : data) {
            listNBT.add((Object)datum.getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.m_128365_(key, (Tag)listNBT);
        }
    }

    public static PaygateTradeData loadData(CompoundTag nbt) {
        PaygateTradeData trade = new PaygateTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<PaygateTradeData> loadAllData(CompoundTag nbt) {
        return PaygateTradeData.loadAllData("Trades", nbt);
    }

    public static List<PaygateTradeData> loadAllData(String key, CompoundTag nbt) {
        ListTag listNBT = nbt.m_128437_(key, 10);
        List<PaygateTradeData> data = PaygateTradeData.listOfSize(listNBT.size());
        for (int i = 0; i < listNBT.size(); ++i) {
            data.get(i).loadFromNBT(listNBT.m_128728_(i));
        }
        return data;
    }

    public static List<PaygateTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new PaygateTradeData());
        }
        return data;
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = super.getAsNBT();
        compound.m_128405_("Duration", this.getDuration());
        if (this.ticketID >= -1L) {
            compound.m_128356_("TicketID", this.ticketID);
            compound.m_128405_("TicketColor", this.ticketColor);
            compound.m_128379_("StoreTicketStubs", this.storeTicketStubs);
        }
        return compound;
    }

    @Override
    protected void loadFromNBT(CompoundTag compound) {
        super.loadFromNBT(compound);
        this.duration = compound.m_128451_("Duration");
        if (compound.m_128441_("TicketID")) {
            this.ticketID = compound.m_128454_("TicketID");
        } else if (compound.m_128441_("Ticket")) {
            this.ticketID = TicketSaveData.getConvertedID(compound.m_128342_("Ticket"));
            this.ticketColor = TicketItem.GetDefaultTicketColor(this.ticketID);
        } else {
            this.ticketID = Long.MIN_VALUE;
        }
        if (compound.m_128441_("TicketColor")) {
            this.ticketColor = compound.m_128451_("TicketColor");
        } else if (this.ticketID >= -1L) {
            this.ticketColor = TicketItem.GetDefaultTicketColor(this.ticketID);
        }
        this.storeTicketStubs = compound.m_128441_("StoreTicketStubs") ? compound.m_128471_("StoreTicketStubs") : false;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        LightmansCurrency.LogWarning("Attempting to compare paygate trades, but paygate trades do not support this interaction.");
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        LightmansCurrency.LogWarning("Attempting to determine if the paygate trades differences are acceptable, but paygate trades do not support this interaction.");
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        LightmansCurrency.LogWarning("Attempting to get warnings for different paygate trades, but paygate trades do not support this interaction.");
        return Lists.newArrayList();
    }

    public static MutableComponent formatDurationShort(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = Component.m_237119_();
        if (hours > 0) {
            result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.hours.short", (Object[])new Object[]{hours}));
        }
        if (minutes > 0) {
            result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.minutes.short", (Object[])new Object[]{minutes}));
        }
        if (seconds > 0) {
            result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.seconds.short", (Object[])new Object[]{seconds}));
        }
        if (ticks > 0 || result.getString().isBlank()) {
            result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.ticks.short", (Object[])new Object[]{ticks}));
        }
        return result;
    }

    public static MutableComponent formatDurationDisplay(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        if (hours > 0) {
            return Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.hours.short", (Object[])new Object[]{hours});
        }
        if (minutes > 0) {
            return Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.minutes.short", (Object[])new Object[]{minutes});
        }
        if (seconds > 0) {
            return Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.seconds.short", (Object[])new Object[]{seconds});
        }
        return Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.ticks.short", (Object[])new Object[]{ticks});
    }

    public static MutableComponent formatDuration(int duration) {
        int ticks = duration % 20;
        int seconds = duration / 20 % 60;
        int minutes = duration / 1200 % 60;
        int hours = duration / 72000;
        MutableComponent result = Component.m_237119_();
        boolean addSpacer = false;
        if (hours > 0) {
            if (addSpacer) {
                result.m_7220_((Component)Component.m_237113_((String)" "));
            }
            addSpacer = true;
            if (hours > 1) {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.hours", (Object[])new Object[]{hours}));
            } else {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.hours.singular", (Object[])new Object[]{hours}));
            }
        }
        if (minutes > 0) {
            if (addSpacer) {
                result.m_7220_((Component)Component.m_237113_((String)" "));
            }
            addSpacer = true;
            if (minutes > 1) {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.minutes", (Object[])new Object[]{minutes}));
            } else {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.minutes.singular", (Object[])new Object[]{minutes}));
            }
        }
        if (seconds > 0) {
            if (addSpacer) {
                result.m_7220_((Component)Component.m_237113_((String)" "));
            }
            addSpacer = true;
            if (seconds > 1) {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.seconds", (Object[])new Object[]{seconds}));
            } else {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.seconds.singular", (Object[])new Object[]{seconds}));
            }
        }
        if (ticks > 0) {
            if (addSpacer) {
                result.m_7220_((Component)Component.m_237113_((String)" "));
            }
            if (ticks > 1) {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.ticks", (Object[])new Object[]{ticks}));
            } else {
                result.m_7220_((Component)Component.m_237110_((String)"tooltip.lightmanscurrency.paygate.duration.ticks.singular", (Object[])new Object[]{ticks}));
            }
        }
        return result;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new PaygateTradeButtonRenderer(this);
    }

    @Override
    public void onInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<CompoundTag> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (heldItem.m_41720_() == ModItems.TICKET_MASTER.get()) {
                this.setTicket(heldItem);
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, 0, button, heldItem);
                }
            } else {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    @Override
    public void onOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<CompoundTag> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    public void onInteraction(@Nonnull BasicTradeEditTab tab, Consumer<CompoundTag> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            int tradeIndex = paygate.getTradeData().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    @Override
    public boolean isMoneyRelevant() {
        return !this.isTicketTrade();
    }
}

