/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ItemTraderData
extends InputTraderData
implements TraderItemStorage.ITraderItemFilter {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{UpgradeType.ITEM_CAPACITY});
    public static final int DEFAULT_STACK_LIMIT = 576;
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trader");
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    protected TraderItemStorage storage = new TraderItemStorage(this);
    protected List<ItemTradeData> trades;

    public IItemHandler getItemHandler(Direction relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    public ItemTraderData() {
        this(TYPE);
    }

    protected ItemTraderData(ResourceLocation type) {
        super(type);
        this.trades = ItemTradeData.listOfSize(1, true);
        this.validateTradeRestrictions();
    }

    public ItemTraderData(int tradeCount, Level level, BlockPos pos) {
        this(TYPE, tradeCount, level, pos);
    }

    protected ItemTraderData(ResourceLocation type, int tradeCount, Level level, BlockPos pos) {
        super(type, level, pos);
        this.trades = ItemTradeData.listOfSize(tradeCount, true);
        this.validateTradeRestrictions();
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        this.saveStorage(compound);
        this.saveTrades(compound);
    }

    protected final void saveStorage(CompoundTag compound) {
        this.storage.save(compound, "ItemStorage");
    }

    @Override
    protected final void saveTrades(CompoundTag compound) {
        ItemTradeData.saveAllData(compound, this.trades);
    }

    @Override
    public void loadAdditional(CompoundTag compound) {
        super.loadAdditional(compound);
        if (compound.m_128441_("ItemStorage")) {
            this.storage.load(compound, "ItemStorage");
        }
        if (compound.m_128441_("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, !this.isPersistent());
            this.validateTradeRestrictions();
        }
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public void addTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() >= 100) {
            return;
        }
        if (CommandLCAdmin.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.getTradeCount() + 1);
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), true, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "add a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public void removeTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (this.getTradeCount() <= 1) {
            return;
        }
        if (CommandLCAdmin.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.getTradeCount() - 1);
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), false, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "remove a trade slot", "LC_ADMIN_MODE");
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.getTradeCount() == MathUtil.clamp(newTradeCount, 1, 100)) {
            return;
        }
        int tradeCount = MathUtil.clamp(newTradeCount, 1, 100);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.validateTradeRestrictions();
        if (this.isServer()) {
            this.markTradesDirty();
        }
    }

    public final void validateTradeRestrictions() {
        for (int i = 0; i < this.trades.size(); ++i) {
            ItemTradeData trade = this.trades.get(i);
            trade.setRestriction(this.getTradeRestriction(i));
        }
    }

    protected ItemTradeRestriction getTradeRestriction(int tradeIndex) {
        return ItemTradeRestriction.NONE;
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData(false);
        }
        return this.trades.get(tradeSlot);
    }

    @Nonnull
    public List<ItemTradeData> getTradeData() {
        return this.trades;
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (trade.sellItemsDefined()) {
            if (this.isCreative()) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @Override
    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemLike)Items.f_42155_);
    }

    @Override
    public MutableComponent inputSettingsTabTooltip() {
        return Component.m_237115_((String)"tooltip.lightmanscurrency.settings.iteminput");
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER;
    }

    @Override
    public boolean hasValidTrade() {
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        JsonArray trades = new JsonArray();
        for (ItemTradeData trade : this.trades) {
            JsonArray ruleData;
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            JsonArray ignoreNBTData = new JsonArray();
            tradeData.addProperty("TradeType", trade.getTradeType().name());
            if (trade.getSellItem(0).m_41619_()) {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                if (trade.hasCustomName(1)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(1));
                }
                if (!trade.getEnforceNBT(1)) {
                    ignoreNBTData.add((Number)0);
                }
            } else {
                tradeData.add("SellItem", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(0)));
                if (trade.hasCustomName(0)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(0));
                }
                if (!trade.getEnforceNBT(0)) {
                    ignoreNBTData.add((Number)0);
                }
                if (!trade.getSellItem(1).m_41619_()) {
                    tradeData.add("SellItem2", (JsonElement)FileUtil.convertItemStack(trade.getSellItem(1)));
                    if (trade.hasCustomName(1)) {
                        tradeData.addProperty("DisplayName2", trade.getCustomName(1));
                    }
                    if (!trade.getEnforceNBT(1)) {
                        ignoreNBTData.add((Number)1);
                    }
                }
            }
            if (trade.isSale() || trade.isPurchase()) {
                tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            }
            if (trade.isBarter()) {
                if (trade.getBarterItem(0).m_41619_()) {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                    if (!trade.getEnforceNBT(3)) {
                        ignoreNBTData.add((Number)2);
                    }
                } else {
                    tradeData.add("BarterItem", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(0)));
                    if (!trade.getEnforceNBT(2)) {
                        ignoreNBTData.add((Number)2);
                    }
                    if (!trade.getBarterItem(1).m_41619_()) {
                        tradeData.add("BarterItem2", (JsonElement)FileUtil.convertItemStack(trade.getBarterItem(1)));
                        if (!trade.getEnforceNBT(3)) {
                            ignoreNBTData.add((Number)3);
                        }
                    }
                }
            }
            if (ignoreNBTData.size() > 0) {
                tradeData.add("IgnoreNBT", (JsonElement)ignoreNBTData);
            }
            if ((ruleData = TradeRule.saveRulesToJson(trade.getRules())).size() > 0) {
                tradeData.add("Rules", (JsonElement)ruleData);
            }
            trades.add((JsonElement)tradeData);
        }
        JsonArray storageData = new JsonArray();
        for (ItemStack item : this.storage.getContents()) {
            boolean shouldWrite = false;
            for (int i = 0; i < this.trades.size() && !shouldWrite; ++i) {
                ItemTradeData trade = this.trades.get(i);
                if (!trade.isValid() || !trade.shouldStorageItemBeSaved(item)) continue;
                shouldWrite = true;
            }
            if (!shouldWrite) continue;
            storageData.add((JsonElement)FileUtil.convertItemStack(item));
        }
        if (storageData.size() > 0) {
            json.add("RelevantStorage", (JsonElement)storageData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Trades")) {
            throw new Exception("Item Trader must have a trade list.");
        }
        JsonArray trades = json.get("Trades").getAsJsonArray();
        this.trades = new ArrayList<ItemTradeData>();
        for (int i = 0; i < trades.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = trades.get(i).getAsJsonObject();
                ItemTradeData newTrade = new ItemTradeData(false);
                newTrade.setItem(FileUtil.parseItemStack(tradeData.get("SellItem").getAsJsonObject()), 0);
                if (tradeData.has("SellItem2")) {
                    newTrade.setItem(FileUtil.parseItemStack(tradeData.get("SellItem2").getAsJsonObject()), 1);
                }
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeType(ItemTradeData.loadTradeType(tradeData.get("TradeType").getAsString()));
                }
                if (tradeData.has("Price")) {
                    if (newTrade.isBarter()) {
                        LightmansCurrency.LogWarning("Price is being defined for a barter trade. Price will be ignored.");
                    } else {
                        newTrade.setCost(CoinValue.Parse(tradeData.get("Price")));
                    }
                } else if (!newTrade.isBarter()) {
                    LightmansCurrency.LogWarning("Price is not defined on a non-barter trade. Price will be assumed to be free.");
                    newTrade.setCost(CoinValue.FREE);
                }
                if (tradeData.has("BarterItem")) {
                    if (newTrade.isBarter()) {
                        newTrade.setItem(FileUtil.parseItemStack(tradeData.get("BarterItem").getAsJsonObject()), 2);
                        if (tradeData.has("BarterItem2")) {
                            newTrade.setItem(FileUtil.parseItemStack(tradeData.get("BarterItem2").getAsJsonObject()), 3);
                        }
                    } else {
                        LightmansCurrency.LogWarning("BarterItem is being defined for a non-barter trade. Barter item will be ignored.");
                    }
                }
                if (tradeData.has("DisplayName")) {
                    newTrade.setCustomName(0, tradeData.get("DisplayName").getAsString());
                }
                if (tradeData.has("DisplayName2")) {
                    newTrade.setCustomName(1, tradeData.get("DisplayName2").getAsString());
                }
                if (tradeData.has("Rules")) {
                    newTrade.setRules(TradeRule.Parse(tradeData.get("Rules").getAsJsonArray(), newTrade));
                }
                if (tradeData.has("IgnoreNBT")) {
                    JsonArray ignoreNBTData = tradeData.getAsJsonArray("IgnoreNBT");
                    for (int j = 0; j < ignoreNBTData.size(); ++j) {
                        int slot = ignoreNBTData.get(j).getAsInt();
                        newTrade.setEnforceNBT(slot, false);
                    }
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing item trade at index " + i, e);
            }
        }
        if (this.trades.size() == 0) {
            throw new Exception("Trader has no valid trades!");
        }
        ArrayList<ItemStack> storage = new ArrayList<ItemStack>();
        if (json.has("RelevantStorage")) {
            JsonArray storageData = json.getAsJsonArray("RelevantStorage");
            for (int i = 0; i < storageData.size(); ++i) {
                try {
                    ItemStack item = FileUtil.parseItemStack(storageData.get(i).getAsJsonObject());
                    storage.add(item);
                    continue;
                }
                catch (Exception e) {
                    LightmansCurrency.LogError("Error parsing storage item at index " + i, e);
                }
            }
        }
        this.storage = new TraderItemStorage.LockedTraderStorage(this, storage);
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<ItemTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            ItemTradeData trade = iterator.next();
            if (TradeRule.savePersistentData(ptTag, trade.getRules(), "RuleData")) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.m_128365_("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound) {
        if (compound.m_128441_("PersistentTradeData")) {
            ListTag tradePersistentData = compound.m_128437_("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                ItemTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.m_128728_(i);
                TradeRule.loadPersistentData(ptTag, trade.getRules(), "RuleData");
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
        results.addAll(this.storage.getSplitContents());
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (trade.isSale()) {
            List<ItemStack> soldItems = trade.getRandomSellItems(this);
            if (soldItems == null) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(soldItems)) {
                LightmansCurrency.LogInfo("Not enough room for the output item. Aborting trade!");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.\nPrice: " + price.getString("0") + "\nAvailable Funds: " + CoinValue.fromNumber(context.getAvailableFunds()).getString("0"));
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            for (int i = 0; i < soldItems.size(); ++i) {
                if (context.putItem(soldItems.get(i))) continue;
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                for (int x = 0; x < i; ++x) {
                    context.collectItem(soldItems.get(x));
                }
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage(), soldItems);
                this.markStorageDirty();
                taxesPaid = this.addStoredMoney(price, true);
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            List<ItemStack> collectableItems = context.getCollectableItems(trade.getItemRequirement(0), trade.getItemRequirement(1));
            if (!context.hasItems(collectableItems)) {
                LightmansCurrency.LogDebug("Not enough items in the item slots to make the purchase.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this, collectableItems) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (!trade.hasStock(context) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough money in storage to pay for the purchased items.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItems(collectableItems);
            context.givePayment(price);
            CoinValue taxesPaid = CoinValue.EMPTY;
            if (!this.isCreative()) {
                for (ItemStack item : collectableItems) {
                    this.getStorage().forceAddItem(item);
                }
                this.markStorageDirty();
                taxesPaid = this.removeStoredMoney(price, true);
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, taxesPaid);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (trade.isBarter()) {
            List<ItemStack> collectableItems = context.getCollectableItems(trade.getItemRequirement(2), trade.getItemRequirement(3));
            if (collectableItems == null) {
                LightmansCurrency.LogDebug("Collectable items returned a null list!");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this, collectableItems) && !this.isCreative()) {
                LightmansCurrency.LogDebug("Not enough room in storage to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_INPUT_SPACE;
            }
            List<ItemStack> soldItems = trade.getRandomSellItems(this);
            if (soldItems == null) {
                LightmansCurrency.LogDebug("Not enough items in storage to carry out the trade at index " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(soldItems)) {
                LightmansCurrency.LogDebug("Not enough space to store the purchased items.");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            context.collectItems(collectableItems);
            for (int i = 0; i < soldItems.size(); ++i) {
                if (context.putItem(soldItems.get(i))) continue;
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                for (int x = 0; x < i; ++x) {
                    context.collectItem(soldItems.get(x));
                }
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), CoinValue.EMPTY));
            if (!this.isCreative()) {
                for (ItemStack item : collectableItems) {
                    this.storage.forceAddItem(item);
                }
                trade.RemoveItemsFromStorage(this.getStorage(), soldItems);
                this.markStorageDirty();
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.runPostTradeEvent(context.getPlayerReference(), trade, price, CoinValue.EMPTY);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_INVALID_TRADE;
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
        menu.setTab(2, new ItemTradeEditTab(menu));
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        for (ItemTradeData trade : this.trades) {
            if (!trade.allowItemInStorage(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction relativeSide) {
        return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.getItemHandler(relativeSide)));
    }
}

