/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.easy.IEasyTickable;
import io.github.lightman314.lightmanscurrency.common.events.AuctionHouseEvent;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction.AuctionTradeCancelTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.auction.MessageStartBid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AuctionHouseTrader
extends TraderData
implements IEasyTickable {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "auction_house");
    public static final IconData ICON = IconData.of(new ResourceLocation("lightmanscurrency", "textures/gui/icons.png"), 96, 16);
    private final List<AuctionTradeData> trades = new ArrayList<AuctionTradeData>();
    Map<UUID, AuctionPlayerStorage> storage = new HashMap<UUID, AuctionPlayerStorage>();

    public static boolean isEnabled() {
        return (Boolean)Config.SERVER.enableAuctionHouse.get();
    }

    public static boolean shouldShowOnTerminal() {
        return AuctionHouseTrader.isEnabled() && (Boolean)Config.SERVER.auctionHouseOnTerminal.get() != false;
    }

    @Override
    public boolean showOnTerminal() {
        return AuctionHouseTrader.shouldShowOnTerminal();
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    public AuctionHouseTrader() {
        super(TYPE);
        this.getOwner().SetCustomOwner(EasyText.translatable("gui.lightmanscurrency.universaltrader.auction.owner", new Object[0]));
    }

    @Override
    public MutableComponent getName() {
        return EasyText.translatable("gui.lightmanscurrency.universaltrader.auction", new Object[0]);
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public AuctionTradeData getTrade(int tradeIndex) {
        try {
            return this.trades.get(tradeIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasPersistentAuction(String id) {
        for (AuctionTradeData trade : this.trades) {
            if (!trade.isPersistentID(id) || !trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public int getTradeIndex(AuctionTradeData trade) {
        return this.trades.indexOf(trade);
    }

    @Override
    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    public AuctionPlayerStorage getStorage(Player player) {
        return this.getStorage(PlayerReference.of(player));
    }

    public AuctionPlayerStorage getStorage(PlayerReference player) {
        if (player == null) {
            return null;
        }
        if (!this.storage.containsKey(player.id)) {
            this.storage.put(player.id, new AuctionPlayerStorage(player));
            this.markStorageDirty();
        }
        return this.storage.get(player.id);
    }

    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public void tick() {
        long currentTime = System.currentTimeMillis();
        boolean changed = false;
        boolean canDelete = this.getUserCount() <= 0;
        for (int i = 0; i < this.trades.size(); ++i) {
            AuctionTradeData trade = this.trades.get(i);
            if (trade.hasExpired(currentTime)) {
                trade.ExecuteTrade(this);
                changed = true;
            }
            if (!canDelete || trade.isValid()) continue;
            this.trades.remove(i);
            --i;
        }
        if (changed) {
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
        }
    }

    @Override
    public int getPermissionLevel(PlayerReference player, String permission) {
        if (Objects.equals(permission, "openStorage") || Objects.equals(permission, "editTrades")) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPermissionLevel(Player player, String permission) {
        if (Objects.equals(permission, "openStorage") || Objects.equals(permission, "editTrades")) {
            return 1;
        }
        return 0;
    }

    @Override
    public void saveAdditional(CompoundTag compound) {
        this.saveTrades(compound);
        this.saveStorage(compound);
    }

    @Override
    protected final void saveTrades(CompoundTag compound) {
        ListTag list = new ListTag();
        for (AuctionTradeData trade : this.trades) {
            list.add((Object)trade.getAsNBT());
        }
        compound.m_128365_("Trades", (Tag)list);
    }

    protected final void saveStorage(CompoundTag compound) {
        ListTag list = new ListTag();
        this.storage.forEach((player, storage) -> list.add((Object)storage.save(new CompoundTag())));
        compound.m_128365_("StorageData", (Tag)list);
    }

    @Override
    public void loadAdditional(CompoundTag compound) {
        int i;
        if (compound.m_128441_("Trades")) {
            this.trades.clear();
            ListTag tradeList = compound.m_128437_("Trades", 10);
            for (i = 0; i < tradeList.size(); ++i) {
                this.trades.add(new AuctionTradeData(tradeList.m_128728_(i)));
            }
        }
        if (compound.m_128441_("StorageData")) {
            this.storage.clear();
            ListTag storageList = compound.m_128437_("StorageData", 10);
            for (i = 0; i < storageList.size(); ++i) {
                AuctionPlayerStorage storageEntry = new AuctionPlayerStorage(storageList.m_128728_(i));
                if (storageEntry.getOwner() == null) continue;
                this.storage.put(storageEntry.getOwner().id, storageEntry);
            }
        }
        if (!this.getOwner().hasOwner()) {
            this.getOwner().SetCustomOwner(Component.m_237115_((String)"gui.lightmanscurrency.universaltrader.auction.owner"));
        }
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    public void addTrade(AuctionTradeData trade, boolean persistent) {
        AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Pre e1 = new AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Pre(this, trade, persistent);
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return;
        }
        trade = e1.getAuction();
        trade.startTimer();
        if (trade.isValid()) {
            this.trades.add(trade);
            this.markTradesDirty();
            AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Post e2 = new AuctionHouseEvent.AuctionEvent.CreateAuctionEvent.Post(this, trade, persistent);
            MinecraftForge.EVENT_BUS.post((Event)e2);
        } else {
            LightmansCurrency.LogError("Auction Trade is not fully valid. Unable to add it to the list.");
        }
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!context.hasPlayer()) {
            return TradeContext.TradeResult.FAIL_NOT_SUPPORTED;
        }
        LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(context.getPlayer()), (Object)new MessageStartBid(this.getID(), tradeIndex));
        return TradeContext.TradeResult.SUCCESS;
    }

    public void makeBid(Player player, TraderMenu menu, int tradeIndex, CoinValue bidAmount) {
        AuctionTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return;
        }
        if (trade.hasExpired(System.currentTimeMillis())) {
            return;
        }
        AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Pre e1 = new AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Pre(this, trade, player, bidAmount);
        if (MinecraftForge.EVENT_BUS.post((Event)e1)) {
            return;
        }
        bidAmount = e1.getBidAmount();
        ItemStack wallet = LightmansCurrency.getWalletStack(player);
        long inventoryValue = MoneyUtil.getValue(menu.getCoinInventory());
        if (!wallet.m_41619_()) {
            inventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (inventoryValue < bidAmount.getValueNumber()) {
            return;
        }
        if (trade.tryMakeBid(this, player, bidAmount)) {
            MoneyUtil.ProcessPayment(menu.getCoinInventory(), player, bidAmount);
            this.markDirty(this::saveTrades);
            this.markDirty(this::saveStorage);
            AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Post e2 = new AuctionHouseEvent.AuctionEvent.AuctionBidEvent.Post(this, trade, player, bidAmount);
            MinecraftForge.EVENT_BUS.post((Event)e2);
        }
    }

    @Override
    @Nonnull
    public List<? extends TradeData> getTradeData() {
        return this.trades == null ? new ArrayList() : this.trades;
    }

    @Override
    public IconData getIcon() {
        return ICON;
    }

    @Override
    public boolean canMakePersistent() {
        return false;
    }

    @Override
    public void saveAdditionalPersistentData(CompoundTag compound) {
    }

    @Override
    public void loadAdditionalPersistentData(CompoundTag data) {
    }

    @Override
    public Function<TradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return trade -> {
            AuctionTradeData at;
            return trade instanceof AuctionTradeData && (at = (AuctionTradeData)trade).isOwner(menu.player) && at.isValid();
        };
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new AuctionStorageTab(menu));
        menu.setTab(2, new AuctionTradeCancelTab(menu));
        menu.setTab(3, new AuctionCreateTab(menu));
    }

    @Override
    public boolean shouldRemove(MinecraftServer server) {
        return false;
    }

    @Override
    public void getAdditionalContents(List<ItemStack> contents) {
    }

    @Override
    protected MutableComponent getDefaultName() {
        return this.getName();
    }

    @Override
    public boolean hasValidTrade() {
        return true;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) {
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return false;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return 0;
    }

    @Override
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
        defaultValues.clear();
    }
}

