/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.NonNullSupplier;

public class Team {
    public static final int MAX_NAME_LENGTH = 32;
    public static final String CATEGORY_MEMBER = "MEMBER";
    public static final String CATEGORY_ADMIN = "ADMIN";
    public static final String CATEGORY_REMOVE = "REMOVE";
    public static final String CATEGORY_OWNER = "OWNER";
    private long id;
    PlayerReference owner = null;
    String teamName = "Some Team";
    private boolean isClient = false;
    List<PlayerReference> admins = Lists.newArrayList();
    List<PlayerReference> members = Lists.newArrayList();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;

    public long getID() {
        return this.id;
    }

    public void overrideID(long newID) {
        this.id = newID;
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.teamName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    public List<PlayerReference> getAdmins() {
        return this.admins;
    }

    public List<PlayerReference> getMembers() {
        return this.members;
    }

    public List<PlayerReference> getAllMembers() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>();
        result.addAll(this.members);
        result.addAll(this.admins);
        result.add(this.owner);
        return result;
    }

    public int getBankLimit() {
        return this.bankAccountLimit;
    }

    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    public boolean canAccessBankAccount(Player player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public BankReference getBankReference() {
        if (this.hasBankAccount()) {
            return TeamBankReference.of(this.id).flagAsClient(this.isClient);
        }
        return null;
    }

    public boolean isOwner(Player player) {
        return this.owner != null && this.owner.is((Entity)player) || CommandLCAdmin.isAdminPlayer(player);
    }

    public boolean isOwner(UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    public boolean isAdmin(Player player) {
        return PlayerReference.listContains(this.admins, player.m_20148_()) || this.isOwner(player);
    }

    public boolean isAdmin(UUID playerID) {
        return PlayerReference.listContains(this.admins, playerID) || this.isOwner(playerID);
    }

    public boolean isMember(Player player) {
        return PlayerReference.listContains(this.members, player.m_20148_()) || this.isAdmin(player);
    }

    public boolean isMember(UUID playerID) {
        return PlayerReference.listContains(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changeAddMember(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_MEMBER);
    }

    public void changeAddAdmin(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_ADMIN);
    }

    public void changeRemoveMember(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_REMOVE);
    }

    public void changeOwner(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_OWNER);
    }

    public void changeName(Player requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            if (this.bankAccount != null) {
                this.bankAccount.updateOwnersName(this.teamName);
            }
            this.markDirty();
        }
    }

    public void changeAny(Player requestor, String playerName, String category) {
        PlayerReference player = PlayerReference.of(this.isClient, playerName);
        if (player == null) {
            return;
        }
        if (category.contentEquals(CATEGORY_MEMBER) && this.isAdmin(requestor)) {
            if (this.isMember(player.id)) {
                return;
            }
            this.members.add(player);
            this.markDirty();
        } else if (category.contentEquals(CATEGORY_ADMIN) && this.isAdmin(requestor)) {
            if (this.isAdmin(player.id)) {
                if (this.isOwner(player.id)) {
                    return;
                }
                if (PlayerReference.of(requestor).is(player) || this.isOwner(requestor)) {
                    PlayerReference.removeFromList(this.admins, player);
                    this.members.add(player);
                    this.markDirty();
                }
            } else if (this.isOwner(requestor)) {
                if (this.isMember(player.id)) {
                    PlayerReference.removeFromList(this.members, player);
                }
                this.admins.add(player);
                this.markDirty();
            }
        } else if (category.contentEquals(CATEGORY_REMOVE) && (this.isAdmin(requestor) || PlayerReference.of(requestor).is(player))) {
            if (!this.isMember(player.id)) {
                return;
            }
            if (this.isAdmin(player.id) && !this.isOwner(requestor) && !PlayerReference.of(requestor).is(player)) {
                return;
            }
            if (this.isOwner(player.id)) {
                return;
            }
            boolean notFound = true;
            if (this.isAdmin(player.id)) {
                PlayerReference.removeFromList(this.admins, player);
            } else {
                PlayerReference.removeFromList(this.members, player);
            }
            if (notFound) {
                return;
            }
            this.markDirty();
        } else if (category.contentEquals(CATEGORY_OWNER) && this.isOwner(requestor)) {
            if (this.owner.is(player)) {
                return;
            }
            this.admins.add(this.owner);
            this.owner = player;
            PlayerReference.removeFromList(this.admins, player);
            PlayerReference.removeFromList(this.members, player);
            this.markDirty();
        }
    }

    public void createBankAccount(Player requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(() -> this.markDirty());
        this.bankAccount.updateOwnersName(this.teamName);
        this.bankAccount.setNotificationConsumer(this::notificationSender);
        this.markDirty();
    }

    private void notificationSender(NonNullSupplier<Notification> notification) {
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (this.bankAccountLimit < 1) {
            sendTo.addAll(this.members);
        }
        if (this.bankAccountLimit < 2) {
            sendTo.addAll(this.admins);
        }
        sendTo.add(this.owner);
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            NotificationSaveData.PushNotification(player.id, (Notification)notification.get());
        }
    }

    public void changeBankLimit(Player requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    private Team(@Nonnull long teamID, @Nonnull PlayerReference owner, @Nonnull String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TeamSaveData.MarkTeamDirty(this.id);
        }
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("ID", this.id);
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        compound.m_128359_("Name", this.teamName);
        ListTag memberList = new ListTag();
        for (int i = 0; i < this.members.size(); ++i) {
            CompoundTag thisMember = this.members.get(i).save();
            memberList.add((Object)thisMember);
        }
        compound.m_128365_("Members", (Tag)memberList);
        ListTag adminList = new ListTag();
        for (int i = 0; i < this.admins.size(); ++i) {
            CompoundTag thisAdmin = this.admins.get(i).save();
            adminList.add((Object)thisAdmin);
        }
        compound.m_128365_("Admins", (Tag)adminList);
        if (this.bankAccount != null) {
            compound.m_128365_("BankAccount", (Tag)this.bankAccount.save());
            compound.m_128405_("BankLimit", this.bankAccountLimit);
        }
        return compound;
    }

    public static Team load(@Nonnull CompoundTag compound) {
        PlayerReference owner = null;
        long id = -1L;
        if (compound.m_128441_("ID")) {
            id = compound.m_128454_("ID");
        }
        if (compound.m_128425_("Owner", 10)) {
            owner = PlayerReference.load(compound.m_128469_("Owner"));
        }
        String name = compound.m_128461_("Name");
        if (owner != null) {
            Team team = Team.of(id, owner, name);
            ListTag adminList = compound.m_128437_("Admins", 10);
            for (int i = 0; i < adminList.size(); ++i) {
                PlayerReference admin = PlayerReference.load(adminList.m_128728_(i));
                if (admin == null) continue;
                team.admins.add(admin);
            }
            ListTag memberList = compound.m_128437_("Members", 10);
            for (int i = 0; i < memberList.size(); ++i) {
                PlayerReference member = PlayerReference.load(memberList.m_128728_(i));
                if (member == null) continue;
                team.members.add(member);
            }
            if (compound.m_128425_("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.m_128469_("BankAccount"));
                if (compound.m_128425_("BankLimit", 3)) {
                    team.bankAccountLimit = compound.m_128451_("BankLimit");
                }
                team.bankAccount.updateOwnersName(team.teamName);
                team.bankAccount.setNotificationConsumer(team::notificationSender);
            }
            return team;
        }
        return null;
    }

    public static Team of(@Nonnull long id, @Nonnull PlayerReference owner, @Nonnull String name) {
        return new Team(id, owner, name);
    }

    public static Comparator<Team> sorterFor(Player player) {
        return new TeamSorter(player);
    }

    private record TeamSorter(Player player) implements Comparator<Team>
    {
        @Override
        public int compare(Team o1, Team o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

