/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes.reference.types;

import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxReferenceType;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TaxableTraderReference
extends TaxableReference {
    public static final TaxReferenceType TYPE = new TraderType();
    private final long traderID;

    public TaxableTraderReference(long traderID) {
        super(TYPE);
        this.traderID = traderID;
    }

    @Override
    @Nullable
    public ITaxable getTaxable(boolean isClient) {
        return TraderSaveData.GetTrader(isClient, this.traderID);
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        tag.m_128356_("TraderID", this.traderID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean matches(TaxableReference otherReference) {
        if (!(otherReference instanceof TaxableTraderReference)) return false;
        TaxableTraderReference ttr = (TaxableTraderReference)otherReference;
        if (ttr.traderID != this.traderID) return false;
        return true;
    }

    private static class TraderType
    extends TaxReferenceType {
        private TraderType() {
            super(new ResourceLocation("lightmanscurrency", "trader"));
        }

        @Override
        public TaxableReference load(CompoundTag tag) {
            return new TaxableTraderReference(tag.m_128454_("TraderID"));
        }
    }
}

