/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes.reference;

import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxReferenceType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class TaxableReference {
    public final TaxReferenceType type;

    protected TaxableReference(TaxReferenceType type) {
        this.type = type;
    }

    @Nullable
    public abstract ITaxable getTaxable(boolean var1);

    public final boolean stillValid(boolean isClient) {
        return this.getTaxable(isClient) != null;
    }

    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.typeID.toString());
        return tag;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    @Nullable
    public static TaxableReference load(CompoundTag tag) {
        ResourceLocation type = new ResourceLocation(tag.m_128461_("Type"));
        TaxReferenceType t = TaxReferenceType.getType(type);
        if (t != null) {
            return t.load(tag);
        }
        return null;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TaxableReference) {
            TaxableReference reference = (TaxableReference)obj;
            return this.matches(reference);
        }
        return false;
    }

    protected abstract boolean matches(TaxableReference var1);
}

