/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes.data;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxableReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class TaxStats {
    private final TaxEntry entry;
    private CoinValue totalCollected = CoinValue.EMPTY;
    private final List<CollectionData> collectionCount = new ArrayList<CollectionData>();
    private int uniqueTaxableCount = 0;
    private CollectionData mostTaxed = null;

    public TaxStats(TaxEntry entry) {
        this.entry = entry;
    }

    public void markDirty() {
        this.entry.markStatsDirty();
    }

    public CoinValue getTotalCollected() {
        return this.totalCollected;
    }

    public int getUniqueTaxableCount() {
        return this.uniqueTaxableCount;
    }

    @Nullable
    public TaxableReference getMostTaxed() {
        this.removeInvalidData();
        return this.mostTaxed == null ? null : this.mostTaxed.reference;
    }

    public int getMostTaxedCount() {
        return this.mostTaxed == null ? 0 : this.mostTaxed.interactionCount;
    }

    public void removeInvalidData() {
        if (this.removeInvalidDataInternal()) {
            this.markDirty();
        }
    }

    private boolean removeInvalidDataInternal() {
        boolean changed = false;
        for (int i = 0; i < this.collectionCount.size(); ++i) {
            CollectionData data = this.collectionCount.get(i);
            if (data.reference != null && data.reference.stillValid(this.entry.isClient())) continue;
            if (this.mostTaxed.equals(data)) {
                this.mostTaxed = null;
            }
            this.collectionCount.remove(i--);
            changed = true;
        }
        if (this.mostTaxed == null && changed) {
            this.recalculateMostTaxed();
        }
        return changed;
    }

    private void recalculateMostTaxed() {
        CollectionData mostTaxed = null;
        int count = 0;
        for (CollectionData data : this.collectionCount) {
            if (data.interactionCount <= count) continue;
            mostTaxed = data;
            count = data.interactionCount;
        }
        if (mostTaxed != null) {
            this.mostTaxed = mostTaxed.copy();
        }
    }

    public void OnTaxesCollected(@Nonnull ITaxable taxable, @Nonnull CoinValue collectedAmount) {
        this.removeInvalidDataInternal();
        this.totalCollected = this.totalCollected.plusValue(collectedAmount);
        TaxableReference reference = taxable.getReference();
        if (reference != null) {
            CollectionData data = this.getDataEntry(reference);
            if (data != null) {
                ++data.interactionCount;
            } else {
                ++this.uniqueTaxableCount;
                data = new CollectionData(reference, 1);
                this.collectionCount.add(data);
            }
            if (this.mostTaxed == null || data.interactionCount > this.mostTaxed.interactionCount) {
                this.mostTaxed = data.copy();
            }
        }
        this.markDirty();
    }

    @Nullable
    private CollectionData getDataEntry(@Nonnull TaxableReference taxable) {
        for (CollectionData data : this.collectionCount) {
            if (data.reference == null || !data.reference.equals(taxable)) continue;
            return data;
        }
        return null;
    }

    public void clear() {
        this.totalCollected = CoinValue.EMPTY;
        this.collectionCount.clear();
        this.uniqueTaxableCount = 0;
        this.mostTaxed = null;
        this.markDirty();
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("TotalCollected", (Tag)this.totalCollected.save());
        ListTag taxableDataList = new ListTag();
        for (CollectionData data : this.collectionCount) {
            if (data.reference == null) continue;
            taxableDataList.add((Object)data.save());
        }
        tag.m_128365_("TaxableInteractions", (Tag)taxableDataList);
        tag.m_128405_("UniqueTaxables", this.uniqueTaxableCount);
        if (this.mostTaxed != null) {
            tag.m_128365_("MostTaxed", (Tag)this.mostTaxed.save());
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("TotalCollected")) {
            this.totalCollected = CoinValue.load(tag.m_128469_("TotalCollected"));
        }
        if (tag.m_128441_("TaxableInteractions")) {
            this.collectionCount.clear();
            ListTag taxableDataList = tag.m_128437_("TaxableInteractions", 10);
            for (int i = 0; i < taxableDataList.size(); ++i) {
                CollectionData d = new CollectionData(taxableDataList.m_128728_(i));
                if (d.reference == null) continue;
                CollectionData d2 = this.getDataEntry(d.reference);
                if (d2 != null) {
                    d2.interactionCount += d.interactionCount;
                    continue;
                }
                this.collectionCount.add(d);
            }
        }
        if (tag.m_128441_("UniqueTaxables")) {
            this.uniqueTaxableCount = tag.m_128451_("UniqueTaxables");
        }
        this.mostTaxed = tag.m_128441_("MostTaxed") ? new CollectionData(tag.m_128469_("MostTaxed")) : null;
    }

    private static class CollectionData {
        public final TaxableReference reference;
        public int interactionCount;

        public CollectionData(TaxableReference reference, int interactionCount) {
            this.reference = reference;
            this.interactionCount = interactionCount;
        }

        public CollectionData(CompoundTag tag) {
            this.reference = TaxableReference.load(tag.m_128469_("Taxable"));
            this.interactionCount = tag.m_128451_("Count");
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            if (this.reference == null) {
                return tag;
            }
            tag.m_128365_("Taxable", (Tag)this.reference.save());
            tag.m_128405_("Count", this.interactionCount);
            return tag;
        }

        public CollectionData copy() {
            return new CollectionData(this.reference, this.interactionCount);
        }
    }
}

