/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes;

import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.List;
import javax.annotation.Nonnull;

public class TaxManager {
    public static List<TaxEntry> GetTaxesForTrader(@Nonnull TraderData trader) {
        return TaxManager.GetTaxes(trader.isClient(), trader);
    }

    public static List<TaxEntry> GetPossibleTaxesForTrader(@Nonnull TraderData trader) {
        return TaxManager.GetPossibleTaxes(trader.isClient(), trader);
    }

    public static List<TaxEntry> GetTaxes(boolean isClient, @Nonnull ITaxable taxable) {
        return TaxSaveData.GetAllTaxEntries(isClient).stream().filter(e -> e.ShouldTax(taxable)).toList();
    }

    public static List<TaxEntry> GetPossibleTaxes(boolean isClient, @Nonnull ITaxable taxable) {
        return TaxSaveData.GetAllTaxEntries(isClient).stream().filter(e -> e.IsInArea(taxable)).toList();
    }
}

