/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.providers.TaxCollectorMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.taxes.TaxesCollectedNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.taxes.data.TaxStats;
import io.github.lightman314.lightmanscurrency.common.taxes.data.WorldArea;
import io.github.lightman314.lightmanscurrency.common.taxes.data.WorldPosition;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.network.NetworkHooks;

public class TaxEntry
implements IClientTracker {
    public final TaxStats stats = new TaxStats(this);
    private boolean locked = true;
    private boolean isClient = false;
    private WorldPosition center = WorldPosition.VOID;
    private int radius = 10;
    private int height = 10;
    private int vertOffset = 0;
    private int renderMode = 1;
    private int taxRate = 1;
    private String name = "";
    private final OwnerData owner = new OwnerData(this, o -> this.markOwnerDirty());
    private CoinValue storedMoney = CoinValue.EMPTY;
    private boolean linkToBank = false;
    private final NotificationData logger = new NotificationData();
    private final List<TaxableReference> acceptedEntries = new ArrayList<TaxableReference>();
    private long id = -1L;
    private boolean active = false;
    private boolean forceAcceptance = false;
    private boolean infiniteRange = false;

    public static int minRadius() {
        return 5;
    }

    public static int maxRadius() {
        return (Integer)Config.SERVER.taxMachineMaxRadius.get();
    }

    public static int minHeight() {
        return 2;
    }

    public static int maxHeight() {
        return (Integer)Config.SERVER.taxMachineMaxHeight.get();
    }

    public static int minVertOffset() {
        return -TaxEntry.maxVertOffset();
    }

    public static int maxVertOffset() {
        return (Integer)Config.SERVER.taxMachineMaxVertOffset.get();
    }

    public static int maxTaxRate() {
        return (Integer)Config.SERVER.taxMachineMaxRate.get();
    }

    public final TaxEntry unlock() {
        this.locked = false;
        return this;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    public final TaxEntry flagAsClient() {
        this.isClient = true;
        return this.unlock();
    }

    public final boolean isServerEntry() {
        return this.id == -9L;
    }

    public WorldPosition getCenter() {
        return this.center;
    }

    public void moveCenter(@Nonnull WorldPosition newPosition) {
        if (this.center.equals(newPosition)) {
            return;
        }
        this.center = newPosition;
        this.markCenterDirty();
    }

    public WorldArea getArea() {
        return this.isInfiniteRange() ? WorldArea.ofInfiniteRange(this.center) : this.center.getArea(this.getRadius(), this.getHeight(), this.getVertOffset());
    }

    public int getRadius() {
        return MathUtil.clamp(this.radius, TaxEntry.minRadius(), TaxEntry.maxRadius());
    }

    public void setRadius(int newRadius) {
        if (this.isInfiniteRange()) {
            return;
        }
        this.radius = MathUtil.clamp(newRadius, TaxEntry.minRadius(), TaxEntry.maxRadius());
        this.markAreaDirty();
    }

    public int getHeight() {
        return MathUtil.clamp(this.height, TaxEntry.minHeight(), TaxEntry.maxHeight());
    }

    public void setHeight(int newHeight) {
        if (this.isInfiniteRange()) {
            return;
        }
        this.height = MathUtil.clamp(newHeight, TaxEntry.minHeight(), TaxEntry.maxHeight());
        this.markAreaDirty();
    }

    public int getVertOffset() {
        return MathUtil.clamp(this.vertOffset, TaxEntry.minVertOffset(), TaxEntry.maxVertOffset());
    }

    public void setVertOffset(int newVertOffset) {
        if (this.isInfiniteRange()) {
            return;
        }
        this.vertOffset = MathUtil.clamp(newVertOffset, TaxEntry.minVertOffset(), TaxEntry.maxVertOffset());
        this.markAreaDirty();
    }

    public int getRenderMode() {
        if (this.isInfiniteRange()) {
            return 0;
        }
        return this.renderMode;
    }

    public void setRenderMode(int newRenderMode) {
        this.renderMode = newRenderMode % 3;
        this.markRenderModeDirty();
    }

    public boolean shouldRender(Player player) {
        if (player == null || this.isInfiniteRange()) {
            return false;
        }
        if (CommandLCAdmin.isAdminPlayer(player)) {
            return true;
        }
        if (this.getRenderMode() == 1) {
            return this.canAccess(player);
        }
        return this.getRenderMode() == 2 && this.isActive();
    }

    public int getRenderColor(Player player) {
        if (this.canAccess(player)) {
            if (this.active) {
                return 51200;
            }
            return 0xC80000;
        }
        if (this.renderMode != 2) {
            if (this.active) {
                return 30464;
            }
            return 0x770000;
        }
        return 0xC8C800;
    }

    public int getTaxRate() {
        return MathUtil.clamp(this.taxRate, 0, (Integer)Config.SERVER.taxMachineMaxRate.get());
    }

    public void setTaxRate(int newPercentage) {
        this.taxRate = MathUtil.clamp(newPercentage, 1, (Integer)Config.SERVER.taxMachineMaxRate.get());
        this.markTaxPercentageDirty();
    }

    public String getCustomName() {
        return this.name;
    }

    public MutableComponent getName() {
        if (this.name.isBlank()) {
            return this.getDefaultName();
        }
        return EasyText.literal(this.name);
    }

    public void setName(String name) {
        this.name = name;
        this.markNameDirty();
    }

    protected MutableComponent getDefaultName() {
        return EasyText.translatable("gui.lightmanscurrency.tax_entry.default_name", this.isServerEntry() ? EasyText.translatable("gui.lightmanscurrency.tax_entry.default_name.server", new Object[0]) : this.owner.getOwnerName());
    }

    public OwnerData getOwner() {
        return this.owner;
    }

    public final boolean canAccess(@Nonnull Player player) {
        if (this.isServerEntry()) {
            return true;
        }
        return this.owner.isMember(player);
    }

    public CoinValue getStoredMoney() {
        return this.storedMoney;
    }

    public void depositMoney(CoinValue amount) {
        BankAccount account = this.getBankAccount();
        if (account != null) {
            account.depositCoins(amount);
            account.LogInteraction(this, amount);
            return;
        }
        this.storedMoney = this.storedMoney.plusValue(amount);
        this.markStoredMoneyDirty();
    }

    public void clearStoredMoney() {
        this.storedMoney = CoinValue.EMPTY;
    }

    @Nonnull
    public final CoinValue CalculateAndPayTaxes(@Nonnull ITaxable taxable, @Nonnull CoinValue taxableAmount) {
        CoinValue amountToPay = taxableAmount.percentageOfValue(this.getTaxRate());
        if (amountToPay.hasAny()) {
            this.depositMoney(amountToPay);
            this.PushNotification(TaxesCollectedNotification.create(taxable.getName(), amountToPay, new TaxEntryCategory(this.getName(), this.id)));
            this.stats.OnTaxesCollected(taxable, amountToPay);
        }
        return amountToPay;
    }

    public void setLinkedToBank(boolean newState) {
        this.linkToBank = newState;
        this.markBankStateDirty();
    }

    public boolean isLinkedToBank() {
        return this.linkToBank && !this.isServerEntry();
    }

    public final BankAccount getBankAccount() {
        if (!this.linkToBank) {
            return null;
        }
        if (this.owner.hasTeam()) {
            Team team = this.owner.getTeam();
            if (team.hasBankAccount()) {
                return team.getBankAccount();
            }
        } else if (this.owner.hasPlayer()) {
            return BankSaveData.GetBankAccount(this.isClient, this.owner.getPlayer().id);
        }
        return null;
    }

    public final List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public final void PushNotification(NonNullSupplier<Notification> notification) {
        if (this.isClient) {
            return;
        }
        this.logger.addNotification((Notification)notification.get());
        this.markNotificationsDirty();
    }

    public final List<TaxableReference> getAcceptedEntries() {
        return ImmutableList.copyOf(this.acceptedEntries);
    }

    public final void acceptTaxes(@Nonnull ITaxable entry) {
        TaxableReference reference = entry.getReference();
        if (!this.acceptedEntries.contains(reference) && reference != null) {
            this.acceptedEntries.add(reference);
            this.markAcceptedEntriesDirty();
        }
    }

    public final void taxableBlockRemoved(@Nonnull ITaxable entry) {
        TaxableReference reference = entry.getReference();
        if (this.acceptedEntries.contains(reference)) {
            this.acceptedEntries.remove(reference);
            this.markAcceptedEntriesDirty();
        }
    }

    public boolean ShouldTax(@Nonnull ITaxable taxable) {
        return this.IsInArea(taxable) && (this.forcesAcceptance() || this.acceptedEntries.contains(taxable.getReference()));
    }

    public boolean IsInArea(@Nonnull ITaxable taxable) {
        return this.isActive() && this.getArea().isInArea(taxable.getWorldPosition());
    }

    public long getID() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean newState, @Nullable Player player) {
        if (this.active == newState) {
            return;
        }
        if (((Boolean)Config.SERVER.taxMachinesAdminOnly.get()).booleanValue() && !CommandLCAdmin.isAdminPlayer(player) && !this.active) {
            Permissions.PermissionWarning(player, "activate a tax entry", "LC_ADMIN_MODE");
            return;
        }
        this.active = newState;
        this.markActiveStateDirty();
    }

    public boolean forcesAcceptance() {
        return this.forceAcceptance || this.isServerEntry();
    }

    public void setForceAcceptance(boolean isAdmin) {
        if (this.isServerEntry()) {
            return;
        }
        this.forceAcceptance = isAdmin;
        this.markAdminStateDirty();
    }

    public boolean isInfiniteRange() {
        return this.infiniteRange || this.isServerEntry();
    }

    public void setInfiniteRange(boolean infiniteRange) {
        if (this.isServerEntry()) {
            return;
        }
        this.infiniteRange = infiniteRange;
        this.markAdminStateDirty();
    }

    protected final void markDirty(CompoundTag packet) {
        if (this.locked || this.isClient) {
            return;
        }
        TaxSaveData.MarkTaxEntryDirty(this.id, packet);
    }

    protected final void markDirty(Function<CompoundTag, CompoundTag> packet) {
        this.markDirty(packet.apply(new CompoundTag()));
    }

    public TaxEntry() {
    }

    public TaxEntry(long id, @Nullable BlockEntity core, @Nullable Player owner) {
        this.id = id;
        if (core != null) {
            this.center = WorldPosition.ofBE(core);
        }
        this.owner.SetOwner(owner);
    }

    public final void openMenu(@Nonnull Player player, @Nonnull MenuValidator validator) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (this.canAccess(player)) {
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new TaxCollectorMenuProvider(this.id, validator), EasyMenu.encoder(d -> d.writeLong(this.id), validator));
            }
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("ID", this.id);
        this.saveTaxRate(tag);
        this.saveStoredMoney(tag);
        this.saveActiveState(tag);
        this.saveName(tag);
        this.saveNotifications(tag);
        this.saveStats(tag);
        if (!this.isServerEntry()) {
            this.saveCenter(tag);
            this.saveArea(tag);
            this.saveRenderMode(tag);
            this.saveOwner(tag);
            this.saveAdminState(tag);
            this.saveAcceptedEntries(tag);
            this.saveBankState(tag);
        }
        return tag;
    }

    public final void markAreaDirty() {
        this.markDirty(this::saveArea);
    }

    protected final CompoundTag saveArea(CompoundTag tag) {
        tag.m_128405_("HorizRadius", this.radius);
        tag.m_128405_("VertSize", this.height);
        tag.m_128405_("VertOffset", this.vertOffset);
        return tag;
    }

    public final void markRenderModeDirty() {
        this.markDirty(this::saveRenderMode);
    }

    protected final CompoundTag saveRenderMode(CompoundTag tag) {
        tag.m_128405_("RenderMode", this.renderMode);
        return tag;
    }

    public final void markCenterDirty() {
        this.markDirty(this::saveCenter);
    }

    protected final CompoundTag saveCenter(CompoundTag tag) {
        tag.m_128365_("Center", (Tag)this.center.save());
        return tag;
    }

    public final void markTaxPercentageDirty() {
        this.markDirty(this::saveTaxRate);
    }

    protected final CompoundTag saveTaxRate(CompoundTag tag) {
        tag.m_128405_("TaxRate", this.taxRate);
        return tag;
    }

    public final void markNameDirty() {
        this.markDirty(this::saveName);
    }

    protected final CompoundTag saveName(CompoundTag tag) {
        tag.m_128359_("CustomName", this.name);
        return tag;
    }

    public final void markOwnerDirty() {
        this.markDirty(this::saveOwner);
    }

    protected final CompoundTag saveOwner(CompoundTag tag) {
        tag.m_128365_("Owner", (Tag)this.owner.save());
        return tag;
    }

    public final void markStoredMoneyDirty() {
        this.markDirty(this::saveStoredMoney);
    }

    protected final CompoundTag saveStoredMoney(CompoundTag tag) {
        tag.m_128365_("StoredMoney", (Tag)this.storedMoney.save());
        return tag;
    }

    public final void markAdminStateDirty() {
        this.markDirty(this::saveAdminState);
    }

    protected final CompoundTag saveAdminState(CompoundTag tag) {
        tag.m_128379_("ForceAcceptance", this.forceAcceptance);
        tag.m_128379_("IsInfiniteRange", this.infiniteRange);
        return tag;
    }

    public final void markActiveStateDirty() {
        this.markDirty(this::saveActiveState);
    }

    protected final CompoundTag saveActiveState(CompoundTag tag) {
        tag.m_128379_("IsActivated", this.active);
        return tag;
    }

    public final void markAcceptedEntriesDirty() {
        this.markDirty(this::saveAcceptedEntries);
    }

    protected final CompoundTag saveAcceptedEntries(CompoundTag tag) {
        ListTag acceptedEntriesList = new ListTag();
        for (TaxableReference entry : this.acceptedEntries) {
            acceptedEntriesList.add((Object)entry.save());
        }
        tag.m_128365_("AcceptedEntries", (Tag)acceptedEntriesList);
        return tag;
    }

    public final void markNotificationsDirty() {
        this.markDirty(this::saveNotifications);
    }

    protected final CompoundTag saveNotifications(CompoundTag tag) {
        tag.m_128365_("Notifications", (Tag)this.logger.save());
        return tag;
    }

    public final void markStatsDirty() {
        this.markDirty(this::saveStats);
    }

    protected final CompoundTag saveStats(CompoundTag tag) {
        tag.m_128365_("Statistics", (Tag)this.stats.save());
        return tag;
    }

    public final void markBankStateDirty() {
        this.markDirty(this::saveBankState);
    }

    protected final CompoundTag saveBankState(CompoundTag tag) {
        tag.m_128379_("LinkedToBank", this.linkToBank);
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ID")) {
            this.id = tag.m_128454_("ID");
        }
        if (tag.m_128441_("Center")) {
            this.center = WorldPosition.load(tag.m_128469_("Center"));
        }
        if (tag.m_128441_("HorizRadius")) {
            this.radius = tag.m_128451_("HorizRadius");
        }
        if (tag.m_128441_("VertSize")) {
            this.height = tag.m_128451_("VertSize");
        }
        if (tag.m_128441_("VertOffset")) {
            this.vertOffset = tag.m_128451_("VertOffset");
        }
        if (tag.m_128441_("RenderMode")) {
            this.renderMode = tag.m_128451_("RenderMode");
        }
        if (tag.m_128441_("TaxRate")) {
            this.taxRate = tag.m_128451_("TaxRate");
        }
        if (tag.m_128441_("CustomName")) {
            this.name = tag.m_128461_("CustomName");
        }
        if (tag.m_128441_("Owner")) {
            this.owner.load(tag.m_128469_("Owner"));
        }
        if (tag.m_128441_("StoredMoney")) {
            this.storedMoney = CoinValue.load(tag.m_128469_("StoredMoney"));
        }
        if (tag.m_128441_("ForceAcceptance")) {
            this.forceAcceptance = tag.m_128471_("ForceAcceptance");
        }
        if (tag.m_128441_("IsInfiniteRange")) {
            this.infiniteRange = tag.m_128471_("IsInfiniteRange");
        }
        if (tag.m_128441_("IsActivated")) {
            this.active = tag.m_128471_("IsActivated");
        }
        if (tag.m_128441_("AcceptedEntries")) {
            ListTag acceptedEntriesList = tag.m_128437_("AcceptedEntries", 10);
            this.acceptedEntries.clear();
            for (int i = 0; i < acceptedEntriesList.size(); ++i) {
                TaxableReference r = TaxableReference.load(acceptedEntriesList.m_128728_(i));
                if (r == null) continue;
                this.acceptedEntries.add(r);
            }
        }
        if (tag.m_128441_("Notifications")) {
            this.logger.load(tag.m_128469_("Notifications"));
        }
        if (tag.m_128441_("Statistics")) {
            this.stats.load(tag.m_128469_("Statistics"));
        }
    }
}

