/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.tickets.TicketSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class PaygateNotification
extends TaxableNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "paygate_trade");
    TraderCategory traderData;
    long ticketID = Long.MIN_VALUE;
    boolean usedPass = false;
    CoinValue cost = CoinValue.EMPTY;
    int duration = 0;
    String customer;

    protected PaygateNotification(PaygateTradeData trade, CoinValue cost, boolean usedPass, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.usedPass = usedPass;
        this.ticketID = trade.getTicketID();
        if (trade.isTicketTrade()) {
            this.ticketID = trade.getTicketID();
        } else {
            this.cost = cost;
        }
        this.duration = trade.getDuration();
        this.customer = customer.getName(false);
    }

    public static NonNullSupplier<Notification> createTicket(PaygateTradeData trade, boolean usedPass, PlayerReference customer, TraderCategory traderData) {
        return () -> new PaygateNotification(trade, CoinValue.EMPTY, usedPass, customer, traderData, CoinValue.EMPTY);
    }

    public static NonNullSupplier<Notification> createMoney(PaygateTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        return () -> new PaygateNotification(trade, cost, false, customer, traderData, taxesPaid);
    }

    public PaygateNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public MutableComponent getNormalMessage() {
        if (this.ticketID >= -1L) {
            if (this.usedPass) {
                return EasyText.translatable("notifications.message.paygate_trade.pass", this.customer, this.ticketID, PaygateTradeData.formatDurationShort(this.duration));
            }
            return EasyText.translatable("notifications.message.paygate_trade.ticket", this.customer, this.ticketID, PaygateTradeData.formatDurationShort(this.duration));
        }
        return EasyText.translatable("notifications.message.paygate_trade.coin", this.customer, this.cost.getString(), PaygateTradeData.formatDurationShort(this.duration));
    }

    @Override
    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("Duration", this.duration);
        if (this.ticketID >= -1L) {
            compound.m_128356_("TicketID", this.ticketID);
            compound.m_128379_("UsedPass", this.usedPass);
        } else {
            compound.m_128365_("Price", (Tag)this.cost.save());
        }
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.duration = compound.m_128451_("Duration");
        if (compound.m_128441_("TicketID")) {
            this.ticketID = compound.m_128454_("TicketID");
        } else if (compound.m_128441_("Ticket")) {
            this.ticketID = TicketSaveData.getConvertedID(compound.m_128342_("Ticket"));
        } else if (compound.m_128441_("Price")) {
            this.cost = CoinValue.safeLoad(compound, "Price");
        }
        if (compound.m_128441_("UsedPass")) {
            this.usedPass = compound.m_128471_("UsedPass");
        }
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof PaygateNotification) {
            PaygateNotification pn = (PaygateNotification)other;
            if (!pn.traderData.matches(this.traderData)) {
                return false;
            }
            if (pn.ticketID != this.ticketID) {
                return false;
            }
            if (pn.usedPass != this.usedPass) {
                return false;
            }
            if (pn.duration != this.duration) {
                return false;
            }
            if (pn.cost.getValueNumber() != this.cost.getValueNumber()) {
                return false;
            }
            if (!pn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(pn);
        }
        return false;
    }
}

