/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemWriteData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class ItemTradeNotification
extends TaxableNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trade");
    TraderCategory traderData;
    ItemTradeData.ItemTradeType tradeType;
    List<ItemWriteData> items;
    CoinValue cost = CoinValue.EMPTY;
    String customer;

    public ItemTradeNotification(ItemTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.tradeType = trade.getTradeType();
        this.items = new ArrayList<ItemWriteData>();
        this.items.add(new ItemWriteData(trade.getSellItem(0), trade.isPurchase() ? "" : trade.getCustomName(0)));
        this.items.add(new ItemWriteData(trade.getSellItem(1), trade.isPurchase() ? "" : trade.getCustomName(1)));
        if (trade.isBarter()) {
            this.items.add(new ItemWriteData(trade.getBarterItem(0), ""));
            this.items.add(new ItemWriteData(trade.getBarterItem(1), ""));
        } else {
            this.cost = cost;
            LightmansCurrency.LogDebug("Created Item Trade Notification of cost " + this.cost.getString("NADA"));
        }
        this.customer = customer.getName(false);
    }

    public static NonNullSupplier<Notification> create(ItemTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory trader, CoinValue taxesPaid) {
        return () -> new ItemTradeNotification(trade, cost, customer, trader, taxesPaid);
    }

    public ItemTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    @Nonnull
    public MutableComponent getNormalMessage() {
        Component cost;
        MutableComponent boughtText = EasyText.translatable("log.shoplog." + this.tradeType.name().toLowerCase(), new Object[0]);
        Component itemText = ItemWriteData.getItemNames(this.items.get(0), this.items.get(1));
        if (this.tradeType == ItemTradeData.ItemTradeType.BARTER) {
            cost = itemText;
            itemText = ItemWriteData.getItemNames(this.items.get(2), this.items.get(3));
        } else {
            cost = this.cost.getComponent("0");
        }
        return EasyText.translatable("notifications.message.item_trade", this.customer, boughtText, itemText, cost);
    }

    @Override
    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeType", this.tradeType.index);
        ListTag itemList = new ListTag();
        for (ItemWriteData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            compound.m_128365_("Price", (Tag)this.cost.save());
        }
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeType = ItemTradeData.ItemTradeType.fromIndex(compound.m_128451_("TradeType"));
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemWriteData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemWriteData(itemList.m_128728_(i)));
        }
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            this.cost = CoinValue.safeLoad(compound, "Price");
        }
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ItemTradeNotification) {
            ItemTradeNotification itn = (ItemTradeNotification)other;
            if (!itn.traderData.matches(this.traderData)) {
                return false;
            }
            if (itn.tradeType != this.tradeType) {
                return false;
            }
            if (itn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                ItemWriteData i1 = this.items.get(i);
                ItemWriteData i2 = itn.items.get(i);
                if (!i1.itemName.getString().equals(i2.itemName.getString())) {
                    return false;
                }
                if (i1.count == i2.count) continue;
                return false;
            }
            if (itn.cost.getValueNumber() != this.cost.getValueNumber()) {
                return false;
            }
            if (!itn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(itn);
        }
        return false;
    }

    @Deprecated(since="v2.1.1.5")
    public static class ItemData
    extends ItemWriteData {
        public ItemData(ItemStack item) {
            super(item);
        }

        public ItemData(ItemStack item, String customName) {
            super(item, customName);
        }

        public ItemData(CompoundTag compound) {
            super(compound);
        }
    }
}

