/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class ChangeSettingNotification
extends Notification {
    public static final ResourceLocation ADVANCED_TYPE = new ResourceLocation("lightmanscurrency", "change_settings_advanced");
    public static final ResourceLocation SIMPLE_TYPE = new ResourceLocation("lightmanscurrency", "change_settings_simple");
    protected PlayerReference player;
    protected String setting;

    protected ChangeSettingNotification(PlayerReference player, String setting) {
        this.player = player;
        this.setting = setting;
    }

    protected ChangeSettingNotification() {
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128359_("Setting", this.setting);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.setting = compound.m_128461_("Setting");
    }

    public static class Simple
    extends ChangeSettingNotification {
        String newValue;

        public Simple(PlayerReference player, String setting, String newValue) {
            super(player, setting);
            this.newValue = newValue;
        }

        public Simple(CompoundTag compound) {
            this.load(compound);
        }

        @Override
        protected ResourceLocation getType() {
            return SIMPLE_TYPE;
        }

        @Override
        public MutableComponent getMessage() {
            return Component.m_237110_((String)"log.settings.change.simple", (Object[])new Object[]{this.player.getName(true), this.setting, this.newValue});
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", this.newValue);
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = compound.m_128461_("NewValue");
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Simple) {
                Simple n = (Simple)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue);
            }
            return false;
        }
    }

    public static class Advanced
    extends ChangeSettingNotification {
        String newValue;
        String oldValue;

        public Advanced(PlayerReference player, String setting, String newValue, String oldValue) {
            super(player, setting);
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public Advanced(CompoundTag compound) {
            this.load(compound);
        }

        @Override
        protected ResourceLocation getType() {
            return ADVANCED_TYPE;
        }

        @Override
        public MutableComponent getMessage() {
            return Component.m_237110_((String)"log.settings.change", (Object[])new Object[]{this.player.getName(true), this.setting, this.oldValue, this.newValue});
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("NewValue", this.newValue);
            compound.m_128359_("OldValue", this.oldValue);
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.newValue = compound.m_128461_("NewValue");
            this.oldValue = compound.m_128461_("OldValue");
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Advanced) {
                Advanced n = (Advanced)other;
                return n.player.is(this.player) && n.setting.equals(this.setting) && n.newValue.equals(this.newValue) && n.oldValue.equals(this.oldValue);
            }
            return false;
        }
    }
}

