/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ChangeNameNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "changed_name");
    private PlayerReference player;
    private String oldName;
    private String newName;

    public ChangeNameNotification(PlayerReference player, String newName, String oldName) {
        this.player = player;
        this.newName = newName;
        this.oldName = oldName;
    }

    public ChangeNameNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    public MutableComponent getMessage() {
        if (this.oldName.isBlank()) {
            return Component.m_237110_((String)"log.settings.changename.set", (Object[])new Object[]{this.player.getName(true), this.newName});
        }
        if (this.newName.isBlank()) {
            return Component.m_237110_((String)"log.settings.changename.reset", (Object[])new Object[]{this.player.getName(true), this.oldName});
        }
        return Component.m_237110_((String)"log.settings.changename", (Object[])new Object[]{this.player.getName(true), this.oldName, this.newName});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128359_("OldName", this.oldName);
        compound.m_128359_("NewName", this.newName);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.oldName = compound.m_128461_("OldName");
        this.newName = compound.m_128461_("NewName");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ChangeNameNotification) {
            ChangeNameNotification n = (ChangeNameNotification)other;
            return n.player.is(this.player) && n.newName.equals(this.newName) && n.oldName.equals(this.oldName);
        }
        return false;
    }
}

