/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ChangeCreativeNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "change_creative");
    PlayerReference player;
    boolean creative;

    public ChangeCreativeNotification(PlayerReference player, boolean creative) {
        this.player = player;
        this.creative = creative;
    }

    public ChangeCreativeNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"log.settings.creativemode", (Object[])new Object[]{this.player.getName(true), Component.m_237115_((String)(this.creative ? "log.settings.enabled" : "log.settings.disabled"))});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128379_("Creative", this.creative);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.creative = compound.m_128471_("Creative");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ChangeCreativeNotification) {
            ChangeCreativeNotification n = (ChangeCreativeNotification)other;
            return n.player.is(this.player) && n.creative == this.creative;
        }
        return false;
    }
}

