/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AddRemoveTradeNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "add_remove_trade");
    PlayerReference player;
    boolean isAdd;
    int newCount;

    public AddRemoveTradeNotification(PlayerReference player, boolean isAdd, int newCount) {
        this.player = player;
        this.isAdd = isAdd;
        this.newCount = newCount;
    }

    public AddRemoveTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"log.settings.addremovetrade", (Object[])new Object[]{this.player.getName(true), Component.m_237115_((String)(this.isAdd ? "log.settings.add" : "log.settings.remove")), this.newCount});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128379_("Add", this.isAdd);
        compound.m_128405_("NewCount", this.newCount);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.isAdd = compound.m_128471_("Add");
        this.newCount = compound.m_128451_("NewCount");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof AddRemoveTradeNotification) {
            AddRemoveTradeNotification n = (AddRemoveTradeNotification)other;
            return n.player.is(this.player) && this.isAdd == n.isAdd && this.newCount == n.newCount;
        }
        return false;
    }
}

