/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class LowBalanceNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "bank_low_balance");
    private MutableComponent accountName;
    private CoinValue value = CoinValue.EMPTY;

    public LowBalanceNotification(MutableComponent accountName, CoinValue value) {
        this.accountName = accountName;
        this.value = value;
    }

    public LowBalanceNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"notifications.message.bank_low_balance", (Object[])new Object[]{this.value.getString()});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128365_("Amount", (Tag)this.value.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.value = CoinValue.safeLoad(compound, "Amount");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof LowBalanceNotification) {
            LowBalanceNotification lbn = (LowBalanceNotification)other;
            if (!lbn.accountName.getString().equals(this.accountName.getString())) {
                return false;
            }
            return lbn.value.getValueNumber() == this.value.getValueNumber();
        }
        return false;
    }
}

