/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class DepositWithdrawNotification
extends Notification {
    public static final ResourceLocation PLAYER_TYPE = new ResourceLocation("lightmanscurrency", "bank_deposit_player");
    public static final ResourceLocation TRADER_TYPE = new ResourceLocation("lightmanscurrency", "bank_deposit_trader");
    public static final ResourceLocation SERVER_TYPE = new ResourceLocation("lightmanscurrency", "bank_deposit_server");
    protected MutableComponent accountName;
    protected boolean isDeposit;
    protected CoinValue amount = CoinValue.EMPTY;

    protected DepositWithdrawNotification(MutableComponent accountName, boolean isDeposit, CoinValue amount) {
        this.accountName = accountName;
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    protected DepositWithdrawNotification() {
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128379_("Deposit", this.isDeposit);
        compound.m_128365_("Amount", (Tag)this.amount.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.isDeposit = compound.m_128471_("Deposit");
        this.amount = CoinValue.safeLoad(compound, "Amount");
    }

    protected abstract MutableComponent getName();

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"log.bank", (Object[])new Object[]{this.getName(), Component.m_237115_((String)(this.isDeposit ? "log.bank.deposit" : "log.bank.withdraw")), this.amount.getComponent()});
    }

    public static class Server
    extends DepositWithdrawNotification {
        public Server(MutableComponent accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
        }

        public Server(CompoundTag compound) {
            this.load(compound);
        }

        @Override
        protected MutableComponent getName() {
            return EasyText.translatable("notifications.bank.server", new Object[0]);
        }

        @Override
        protected ResourceLocation getType() {
            return SERVER_TYPE;
        }

        @Override
        protected boolean canMerge(Notification other) {
            return false;
        }
    }

    public static class Trader
    extends DepositWithdrawNotification {
        MutableComponent traderName;

        public Trader(MutableComponent traderName, MutableComponent accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
            this.traderName = traderName;
        }

        public Trader(CompoundTag compound) {
            this.load(compound);
        }

        @Override
        protected MutableComponent getName() {
            return this.traderName;
        }

        @Override
        protected ResourceLocation getType() {
            return TRADER_TYPE;
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128359_("Trader", Component.Serializer.m_130703_((Component)this.traderName));
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.traderName = Component.Serializer.m_130701_((String)compound.m_128461_("Trader"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Trader) {
                Trader n = (Trader)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.traderName.equals((Object)this.traderName);
            }
            return false;
        }
    }

    public static class Player
    extends DepositWithdrawNotification {
        PlayerReference player;

        public Player(PlayerReference player, MutableComponent accountName, boolean isDeposit, CoinValue amount) {
            super(accountName, isDeposit, amount);
            this.player = player;
        }

        public Player(CompoundTag compound) {
            this.load(compound);
        }

        @Override
        protected MutableComponent getName() {
            return this.player.getNameComponent(true);
        }

        @Override
        protected ResourceLocation getType() {
            return PLAYER_TYPE;
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
            super.saveAdditional(compound);
            compound.m_128365_("Player", (Tag)this.player.save());
        }

        @Override
        protected void loadAdditional(CompoundTag compound) {
            super.loadAdditional(compound);
            this.player = PlayerReference.load(compound.m_128469_("Player"));
        }

        @Override
        protected boolean canMerge(Notification other) {
            if (other instanceof Player) {
                Player n = (Player)other;
                return n.accountName.equals((Object)this.accountName) && n.isDeposit == this.isDeposit && n.amount.equals(this.amount) && n.player.is(this.player);
            }
            return false;
        }
    }
}

