/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BankTransferNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "bank_transfer");
    PlayerReference player;
    CoinValue amount = CoinValue.EMPTY;
    MutableComponent accountName;
    MutableComponent otherAccount;
    boolean wasReceived;

    public BankTransferNotification(CompoundTag compound) {
        this.load(compound);
    }

    public BankTransferNotification(PlayerReference player, CoinValue amount, MutableComponent accountName, MutableComponent otherAccount, boolean wasReceived) {
        this.player = player;
        this.amount = amount;
        this.accountName = accountName;
        this.otherAccount = otherAccount;
        this.wasReceived = wasReceived;
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237110_((String)"log.bank.transfer", (Object[])new Object[]{this.player.getName(true), this.amount.getComponent(), Component.m_237115_((String)(this.wasReceived ? "log.bank.transfer.from" : "log.bank.transfer.to")), this.otherAccount});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128365_("Amount", (Tag)this.amount.save());
        compound.m_128359_("Account", Component.Serializer.m_130703_((Component)this.accountName));
        compound.m_128359_("Other", Component.Serializer.m_130703_((Component)this.otherAccount));
        compound.m_128379_("Received", this.wasReceived);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.amount = CoinValue.safeLoad(compound, "Amount");
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Account"));
        this.otherAccount = Component.Serializer.m_130701_((String)compound.m_128461_("Other"));
        this.wasReceived = compound.m_128471_("Received");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof BankTransferNotification) {
            BankTransferNotification n = (BankTransferNotification)other;
            return n.player.is(this.player) && n.amount.equals(this.amount) && n.accountName.equals((Object)this.accountName) && n.otherAccount.equals((Object)this.otherAccount) && n.wasReceived == this.wasReceived;
        }
        return false;
    }
}

