/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemWriteData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AuctionHouseBidNotification
extends AuctionHouseNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "auction_house_outbid");
    List<ItemWriteData> items;
    CoinValue cost;
    String customer;

    public AuctionHouseBidNotification(AuctionTradeData trade) {
        this.cost = trade.getLastBidAmount();
        this.customer = trade.getLastBidPlayer().getName(false);
        this.items = new ArrayList<ItemWriteData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemWriteData(trade.getAuctionItems().get(i)));
        }
    }

    public AuctionHouseBidNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public MutableComponent getMessage() {
        Component itemText = this.getItemNames(this.items);
        MutableComponent cost = this.cost.getComponent("0");
        return Component.m_237110_((String)"notifications.message.auction.outbid", (Object[])new Object[]{this.customer, itemText, cost});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag itemList = new ListTag();
        for (ItemWriteData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        compound.m_128365_("Price", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemWriteData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemWriteData(itemList.m_128728_(i)));
        }
        this.cost = CoinValue.safeLoad(compound, "Price");
        this.customer = compound.m_128461_("Customer");
    }
}

