/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class TaxableNotification
extends Notification {
    private CoinValue taxesPaid = CoinValue.EMPTY;

    protected TaxableNotification(@Nonnull CoinValue taxesPaid) {
        this.taxesPaid = taxesPaid;
    }

    protected TaxableNotification() {
    }

    @Override
    public final MutableComponent getMessage() {
        if (this.taxesPaid.hasAny()) {
            return this.getNormalMessage().m_130946_("\n").m_7220_((Component)EasyText.translatable("notifications.message.taxes.paid", this.taxesPaid.getComponent("ERROR")));
        }
        return this.getNormalMessage();
    }

    @Nonnull
    protected abstract MutableComponent getNormalMessage();

    @Override
    protected final void saveAdditional(CompoundTag compound) {
        this.saveNormal(compound);
        compound.m_128365_("TaxesPaid", (Tag)this.taxesPaid.save());
    }

    protected abstract void saveNormal(CompoundTag var1);

    @Override
    protected final void loadAdditional(CompoundTag compound) {
        this.taxesPaid = CoinValue.safeLoad(compound, "TaxesPaid");
        this.loadNormal(compound);
    }

    protected abstract void loadNormal(CompoundTag var1);

    protected boolean TaxesMatch(TaxableNotification other) {
        return other.taxesPaid.equals(this.taxesPaid);
    }
}

