/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NotificationData {
    List<Notification> notifications = new ArrayList<Notification>();

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public List<Notification> getNotifications(NotificationCategory category) {
        if (category == NotificationCategory.GENERAL) {
            return this.notifications;
        }
        ArrayList<Notification> result = new ArrayList<Notification>();
        for (Notification not : this.notifications) {
            if (!category.matches(not.getCategory())) continue;
            result.add(not);
        }
        return result;
    }

    public boolean unseenNotification() {
        return this.unseenNotification(NotificationCategory.GENERAL);
    }

    public boolean unseenNotification(NotificationCategory category) {
        for (Notification n : this.getNotifications(category)) {
            if (n.wasSeen()) continue;
            return true;
        }
        return false;
    }

    public List<NotificationCategory> getCategories() {
        ArrayList<NotificationCategory> result = new ArrayList<NotificationCategory>();
        for (Notification not : this.notifications) {
            NotificationCategory category = not.getCategory();
            if (category == null || !result.stream().noneMatch(cat -> cat.matches(category))) continue;
            result.add(category);
        }
        return result;
    }

    public void addNotification(Notification newNotification) {
        Notification mostRecent;
        boolean shouldAdd = true;
        if (this.notifications.size() > 0 && (mostRecent = this.notifications.get(0)).onNewNotification(newNotification)) {
            shouldAdd = false;
        }
        if (shouldAdd) {
            this.notifications.add(0, newNotification);
        }
        this.validateListSize();
    }

    private void validateListSize() {
        int limit = (Integer)Config.SERVER.notificationLimit.get();
        while (this.notifications.size() > limit) {
            this.notifications.remove(this.notifications.size() - 1);
        }
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        ListTag notificationList = new ListTag();
        for (Notification notification : this.notifications) {
            notificationList.add((Object)notification.save());
        }
        compound.m_128365_("Notifications", (Tag)notificationList);
        return compound;
    }

    public static NotificationData loadFrom(CompoundTag compound) {
        NotificationData data = new NotificationData();
        data.load(compound);
        return data;
    }

    public void load(CompoundTag compound) {
        if (compound.m_128425_("Notifications", 9)) {
            this.notifications = new ArrayList<Notification>();
            ListTag notificationList = compound.m_128437_("Notifications", 10);
            for (int i = 0; i < notificationList.size(); ++i) {
                CompoundTag notTag = notificationList.m_128728_(i);
                Notification not = Notification.deserialize(notTag);
                if (not == null) continue;
                this.notifications.add(not);
            }
            this.validateListSize();
        }
    }
}

