/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class NotificationCategory
implements ITab {
    public static final ResourceLocation GENERAL_TYPE = new ResourceLocation("lightmanscurrency", "general");
    private static final Map<String, Function<CompoundTag, NotificationCategory>> DESERIALIZERS = new HashMap<String, Function<CompoundTag, NotificationCategory>>();
    public static final NotificationCategory GENERAL = new NotificationCategory(){

        @Override
        @NotNull
        public IconData getIcon() {
            return IconData.of((ItemLike)Items.f_42009_);
        }

        @Override
        public MutableComponent getName() {
            return Component.m_237115_((String)"notifications.source.general");
        }

        @Override
        public boolean matches(NotificationCategory other) {
            return other == GENERAL;
        }

        @Override
        protected ResourceLocation getType() {
            return GENERAL_TYPE;
        }

        @Override
        protected void saveAdditional(CompoundTag compound) {
        }
    };

    public static void registerInstance(ResourceLocation type, NotificationCategory instance) {
        NotificationCategory.register(type, c -> instance);
    }

    public static void register(ResourceLocation type, Function<CompoundTag, NotificationCategory> deserializer) {
        String t = type.toString();
        if (DESERIALIZERS.containsKey(t)) {
            LightmansCurrency.LogError("Category of type " + t + " is already registered.");
            return;
        }
        if (deserializer == null) {
            LightmansCurrency.LogError("Deserializer of category type " + t + " is null. Unable to register.");
            return;
        }
        DESERIALIZERS.put(t, deserializer);
    }

    public static NotificationCategory deserialize(CompoundTag compound) {
        if (compound.m_128441_("type")) {
            String type = compound.m_128461_("type");
            if (DESERIALIZERS.containsKey(type)) {
                return DESERIALIZERS.get(type).apply(compound);
            }
            LightmansCurrency.LogError("Cannot deserialize notification type " + type + " as no deserializer has been registered.");
            return GENERAL;
        }
        LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag.");
        return GENERAL;
    }

    public final MutableComponent getTooltip() {
        return this.getName();
    }

    public abstract MutableComponent getName();

    @Override
    public final int getColor() {
        return 0xFFFFFF;
    }

    protected abstract ResourceLocation getType();

    public abstract boolean matches(NotificationCategory var1);

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("type", this.getType().toString());
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final boolean notGeneral() {
        return this != GENERAL;
    }
}

