/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CoinValue {
    public static final CoinValue EMPTY = new CoinValue();
    public static final CoinValue FREE = new CoinValue(){

        @Override
        public boolean isFree() {
            return true;
        }
    };
    public final ImmutableList<CoinValuePair> coinValues;

    public boolean isFree() {
        return false;
    }

    public boolean hasAny() {
        return this.coinValues.size() > 0;
    }

    public boolean isValid() {
        return this.isFree() || this.coinValues.size() > 0;
    }

    private CoinValue() {
        this.coinValues = ImmutableList.of();
    }

    private CoinValue(List<CoinValuePair> values) {
        this.coinValues = ImmutableList.copyOf(CoinValue.roundValue(values));
    }

    public static CoinValue create(@Nonnull List<CoinValuePair> coinValues) {
        return coinValues.size() == 0 ? EMPTY : new CoinValue(coinValues);
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.isFree()) {
            compound.m_128379_("Free", true);
        } else {
            ListTag valueList = new ListTag();
            for (CoinValuePair pair : this.coinValues) {
                valueList.add((Object)pair.save());
            }
            compound.m_128365_("Value", (Tag)valueList);
        }
        return compound;
    }

    @Nonnull
    public static CoinValue load(CompoundTag compound) {
        if (compound.m_128425_("Free", 1)) {
            return FREE;
        }
        if (compound.m_128425_("Value", 9)) {
            ListTag valueList = compound.m_128437_("Value", 10);
            ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
            for (int i = 0; i < valueList.size(); ++i) {
                try {
                    pairList.add(CoinValuePair.load(valueList.m_128728_(i)));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return CoinValue.create(pairList);
        }
        return EMPTY;
    }

    @Nonnull
    public static CoinValue safeLoad(CompoundTag compound, String key) {
        if (compound.m_128425_(key, 10)) {
            return CoinValue.load(compound.m_128469_(key));
        }
        if (compound.m_128425_(key, 3)) {
            return CoinValue.fromNumber(compound.m_128451_(key));
        }
        if (compound.m_128425_(key, 9)) {
            ListTag listNBT = compound.m_128437_(key, 10);
            ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag thisCompound = listNBT.m_128728_(i);
                Item priceCoin = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(thisCompound.m_128461_("id")));
                int amount = thisCompound.m_128451_("amount");
                pairList.add(new CoinValuePair(priceCoin, amount));
            }
            return CoinValue.create(pairList);
        }
        if (compound.m_128425_(key, 1)) {
            return FREE;
        }
        return EMPTY;
    }

    public static CoinValue fromNumber(long valueNumber) {
        if (valueNumber <= 0L) {
            return EMPTY;
        }
        List<ItemStack> coinItems = MoneyUtil.getCoinsOfValue(valueNumber);
        ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
        for (ItemStack stack : coinItems) {
            Item coinItem = stack.m_41720_();
            int amount = stack.m_41613_();
            for (int i = 0; i < pairList.size(); ++i) {
                if (((CoinValuePair)pairList.get((int)i)).coin != coinItem) continue;
                pairList.set(i, ((CoinValuePair)pairList.get(i)).addAmount(amount));
                amount = 0;
            }
            if (amount <= 0) continue;
            pairList.add(new CoinValuePair(coinItem, amount));
        }
        return CoinValue.create(pairList);
    }

    public static CoinValue fromInventory(List<ItemStack> inventory) {
        long value = 0L;
        for (ItemStack itemStack : inventory) {
            value += MoneyUtil.getValue(itemStack);
        }
        return CoinValue.fromNumber(value);
    }

    public static CoinValue fromInventory(Container inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            value += MoneyUtil.getValue(inventory.m_8020_(i));
        }
        return CoinValue.fromNumber(value);
    }

    public final void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isFree());
        if (!this.isFree()) {
            buffer.writeInt(this.coinValues.size());
            for (CoinValuePair pair : this.coinValues) {
                pair.encode(buffer);
            }
        }
    }

    public static CoinValue decode(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return FREE;
        }
        int pairCount = buffer.readInt();
        if (pairCount <= 0) {
            return EMPTY;
        }
        ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
        while (pairCount-- > 0) {
            pairList.add(CoinValuePair.decode(buffer));
        }
        return CoinValue.create(pairList);
    }

    @Nonnull
    public CoinValue plusValue(@Nonnull CoinValue otherValue) {
        return CoinValue.fromNumber(this.getValueNumber() + otherValue.getValueNumber());
    }

    @Nonnull
    public CoinValue plusValue(@Nonnull Item coin, int amount) {
        return CoinValue.fromNumber(this.getValueNumber() + MoneyUtil.getValue(coin) * (long)amount);
    }

    @Nonnull
    public CoinValue minusValue(@Nonnull CoinValue otherValue) {
        return CoinValue.fromNumber(this.getValueNumber() - otherValue.getValueNumber());
    }

    @Nonnull
    public CoinValue minusValue(@Nonnull Item coin, int amount) {
        return CoinValue.fromNumber(this.getValueNumber() - MoneyUtil.getValue(coin) * (long)amount);
    }

    @Nonnull
    public CoinValue percentageOfValue(int percentage) {
        return this.percentageOfValue(percentage, false);
    }

    @Nonnull
    public CoinValue percentageOfValue(int percentage, boolean roundUp) {
        if (percentage == 100) {
            return this;
        }
        if (percentage == 0) {
            return FREE;
        }
        long value = this.getValueNumber();
        long newValue = value * (long)MathUtil.clamp(percentage, 0, Integer.MAX_VALUE) / 100L;
        if (roundUp) {
            double newValueD = (double)value * ((double)percentage / 100.0);
            if (roundUp && newValueD % 1.0 != 0.0 && newValueD > (double)newValue) {
                ++newValue;
            }
        }
        if (newValue == 0L) {
            return FREE;
        }
        return CoinValue.fromNumber(newValue);
    }

    private static List<CoinValuePair> roundValue(List<CoinValuePair> list) {
        while (CoinValue.needsRounding(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (!CoinValue.needsRounding(list, i)) continue;
                CoinValuePair pair = list.get(i);
                Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
                int largeAmount = 0;
                while (pair.amount >= (Integer)conversion.getSecond()) {
                    ++largeAmount;
                    pair = pair.removeAmount((Integer)conversion.getSecond());
                }
                if (pair.amount == 0) {
                    list.remove(i);
                    --i;
                } else {
                    list.set(i, pair);
                }
                for (int j = 0; j < list.size(); ++j) {
                    if (list.get((int)j).coin != conversion.getFirst()) continue;
                    list.set(j, list.get(j).addAmount(largeAmount));
                    largeAmount = 0;
                }
                if (largeAmount <= 0) continue;
                list.add(new CoinValuePair((Item)conversion.getFirst(), largeAmount));
            }
        }
        return CoinValue.sortValue(list);
    }

    private static List<CoinValuePair> sortValue(List<CoinValuePair> list) {
        ArrayList<CoinValuePair> newList = new ArrayList<CoinValuePair>();
        while (list.size() > 0) {
            long largestValue = MoneyUtil.getValue(list.get((int)0).coin);
            int largestIndex = 0;
            for (int i = 1; i < list.size(); ++i) {
                long thisValue = MoneyUtil.getValue(list.get((int)i).coin);
                if (thisValue <= largestValue) continue;
                largestIndex = i;
                largestValue = thisValue;
            }
            newList.add(list.get(largestIndex));
            list.remove(largestIndex);
        }
        return newList;
    }

    private static boolean needsRounding(List<CoinValuePair> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!CoinValue.needsRounding(list, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsRounding(List<CoinValuePair> list, int index) {
        CoinValuePair pair = list.get(index);
        Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
        if (conversion != null) {
            return pair.amount >= (Integer)conversion.getSecond();
        }
        return false;
    }

    public List<CoinValuePair> getEntries() {
        return this.coinValues;
    }

    public List<ItemStack> getAsItemList() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (CoinValuePair entry : this.coinValues) {
            items.add(new ItemStack((ItemLike)entry.coin, entry.amount));
        }
        return items;
    }

    public int getEntry(Item coinItem) {
        for (CoinValuePair pair : this.coinValues) {
            if (pair.coin != coinItem) continue;
            return pair.amount;
        }
        return 0;
    }

    public double getDisplayValue() {
        double totalValue = 0.0;
        for (CoinValuePair pricePair : this.coinValues) {
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            totalValue += coinData.getDisplayValue() * (double)pricePair.amount;
        }
        return totalValue;
    }

    public String getString() {
        return this.getString("");
    }

    public String getString(String emptyFiller) {
        return this.getComponent(emptyFiller).getString();
    }

    public MutableComponent getComponent() {
        return this.getComponent("");
    }

    public MutableComponent getComponent(String emptyFiller) {
        return this.getComponent(EasyText.literal(emptyFiller));
    }

    public MutableComponent getComponent(MutableComponent emptyFiller) {
        if (this.isFree()) {
            return EasyText.translatable("gui.coinvalue.free", new Object[0]);
        }
        switch ((ValueType)((Object)Config.SERVER.coinValueType.get())) {
            case DEFAULT: {
                StringBuilder string = new StringBuilder();
                for (CoinValuePair pricePair : this.coinValues) {
                    CoinData coinData = MoneyUtil.getData(pricePair.coin);
                    if (coinData == null) continue;
                    string.append(pricePair.amount);
                    string.append(coinData.getInitial().getString());
                }
                if (string.toString().isBlank()) {
                    return emptyFiller;
                }
                return EasyText.literal(string.toString());
            }
            case VALUE: {
                return EasyText.literal(Config.formatValueDisplay(this.getDisplayValue()));
            }
        }
        return EasyText.literal("?");
    }

    public long getValueNumber() {
        long value = 0L;
        for (CoinValuePair pricePair : this.coinValues) {
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            value += (long)pricePair.amount * coinData.getValue();
        }
        return value;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.isFree()) {
            json.addProperty("Free", Boolean.valueOf(true));
        } else {
            JsonArray array = new JsonArray();
            for (CoinValuePair pair : this.coinValues) {
                array.add((JsonElement)pair.toJson());
            }
            json.add("Value", (JsonElement)array);
        }
        return json;
    }

    public static CoinValue Parse(JsonElement json) throws Exception {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return CoinValue.fromNumber(primitive.getAsNumber().longValue());
            }
            if (primitive.isBoolean() && primitive.getAsBoolean()) {
                return FREE;
            }
            if (primitive.isString()) {
                double displayValue = Double.parseDouble(primitive.getAsString());
                return MoneyUtil.displayValueToCoinValue(displayValue);
            }
        } else {
            if (json.isJsonArray()) {
                JsonArray list = json.getAsJsonArray();
                ArrayList<CoinValuePair> valuePairs = new ArrayList<CoinValuePair>();
                for (int i = 0; i < list.size(); ++i) {
                    JsonObject coinData = list.get(i).getAsJsonObject();
                    Item coinItem = Items.f_41852_;
                    int quantity = 1;
                    if (coinData.has("Coin")) {
                        coinItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(coinData.get("Coin").getAsString()));
                    }
                    if (coinData.has("Count")) {
                        quantity = coinData.get("Count").getAsInt();
                    }
                    if (quantity <= 0) {
                        LightmansCurrency.LogWarning("Coin Count (" + quantity + ") is <= 0. Entry will be ignored.");
                        continue;
                    }
                    if (!MoneyUtil.isCoin(coinItem)) {
                        LightmansCurrency.LogWarning("Coin Item (" + ForgeRegistries.ITEMS.getKey((Object)coinItem) + ") is not a valid coin. Entry will be ignored.");
                        continue;
                    }
                    valuePairs.add(new CoinValuePair(coinItem, quantity));
                }
                if (valuePairs.size() == 0) {
                    throw new Exception("Coin Value entry has no valid coin/count entries to parse.");
                }
                return CoinValue.create(valuePairs);
            }
            if (json.isJsonObject()) {
                JsonPrimitive f2;
                JsonElement f;
                JsonObject j = json.getAsJsonObject();
                if (j.has("Free") && (f = j.get("Free")).isJsonPrimitive() && (f2 = f.getAsJsonPrimitive()).isBoolean() && f2.getAsBoolean()) {
                    return FREE;
                }
                if (j.has("Value")) {
                    JsonArray valueList = j.get("Value").getAsJsonArray();
                    ArrayList<CoinValuePair> pairs = new ArrayList<CoinValuePair>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        try {
                            pairs.add(CoinValuePair.fromJson(valueList.get(i).getAsJsonObject()));
                            continue;
                        }
                        catch (Throwable t) {
                            LightmansCurrency.LogError("Error Parsing Coin Value Entry #" + (i + 1), t);
                        }
                    }
                    return CoinValue.create(pairs);
                }
            }
        }
        throw new Exception("Coin Value entry input is not a valid Json Element.");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isFree(), this.coinValues});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CoinValue) {
            CoinValue coinValue = (CoinValue)other;
            return coinValue.getValueNumber() == this.getValueNumber() && coinValue.isFree() == this.isFree();
        }
        return false;
    }

    public static class CoinValuePair {
        public final Item coin;
        public final int amount;

        public CoinValuePair addAmount(int amount) {
            return new CoinValuePair(this.coin, this.amount + amount);
        }

        public CoinValuePair removeAmount(int amount) {
            return new CoinValuePair(this.coin, this.amount - amount);
        }

        public CoinValuePair(Item coin, int amount) {
            this.coin = coin;
            this.amount = amount;
        }

        public CoinValuePair copy() {
            return new CoinValuePair(this.coin, this.amount);
        }

        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Coin", ForgeRegistries.ITEMS.getKey((Object)this.coin).toString());
            compound.m_128405_("Amount", this.amount);
            return compound;
        }

        public static CoinValuePair load(CompoundTag compound) {
            return CoinValuePair.from(compound.m_128461_("Coin"), compound.m_128451_("Amount"));
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.m_130070_(ForgeRegistries.ITEMS.getKey((Object)this.coin).toString());
            buffer.writeInt(this.amount);
        }

        public static CoinValuePair decode(FriendlyByteBuf buffer) {
            return CoinValuePair.from(buffer.m_130277_(), buffer.readInt());
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("Coin", ForgeRegistries.ITEMS.getKey((Object)this.coin).toString());
            json.addProperty("Amount", (Number)this.amount);
            return json;
        }

        @Nonnull
        public static CoinValuePair fromJson(JsonObject json) throws Exception {
            Item coinItem = Items.f_41852_;
            int quantity = 1;
            if (json.has("Coin")) {
                coinItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("Coin").getAsString()));
            }
            if (json.has("Amount")) {
                quantity = json.get("Amount").getAsInt();
            }
            if (quantity <= 0) {
                throw new RuntimeException("Coin Amount (" + quantity + ") is <= 0!");
            }
            if (!MoneyUtil.isCoin(coinItem)) {
                throw new RuntimeException("Coin Item (" + ForgeRegistries.ITEMS.getKey((Object)coinItem) + ") is not a valid coin!");
            }
            return new CoinValuePair(coinItem, quantity);
        }

        private static CoinValuePair from(String itemID, int amount) {
            return new CoinValuePair((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID)), amount);
        }
    }

    public static enum ValueType {
        DEFAULT,
        VALUE;

    }
}

