/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation.types;

import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockValidator
extends MenuValidator {
    public static final MenuValidatorType TYPE = new Type();
    private final BlockPos pos;
    private final Block block;

    protected BlockValidator(@Nonnull BlockPos pos, @Nonnull Block block) {
        super(TYPE);
        this.pos = pos;
        this.block = block;
    }

    public static MenuValidator of(@Nonnull BlockPos pos, @Nonnull Block block) {
        return new BlockValidator(pos, block);
    }

    @Override
    protected void encodeAdditional(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(ForgeRegistries.BLOCKS.getKey((Object)this.block).toString());
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag) {
        tag.m_128365_("Position", (Tag)TagUtil.saveBlockPos(this.pos));
        tag.m_128359_("Block", ForgeRegistries.BLOCKS.getKey((Object)this.block).toString());
    }

    @Override
    public boolean stillValid(@Nonnull Player player) {
        return player.m_9236_().m_8055_(this.pos).m_60713_(this.block) && player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    private static final class Type
    extends MenuValidatorType {
        private Type() {
            super(new ResourceLocation("lightmanscurrency", "block"));
        }

        @Override
        @Nonnull
        public MenuValidator decode(@Nonnull FriendlyByteBuf buffer) {
            return BlockValidator.of(buffer.m_130135_(), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.m_130277_())));
        }

        @Override
        @Nonnull
        public MenuValidator load(@Nonnull CompoundTag tag) {
            return BlockValidator.of(TagUtil.loadBlockPos(tag.m_128469_("Position")), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("Block"))));
        }
    }
}

