/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trade_rules;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRulesTab
extends TraderStorageTab {
    @Nullable
    public abstract ITradeRuleHost getHost();

    protected TradeRulesTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.hasPermission("editTradeRules");
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void EditTradeRule(@Nonnull ResourceLocation type, @Nonnull CompoundTag updateMessage) {
        if (!this.menu.hasPermission("editTradeRules")) {
            return;
        }
        ITradeRuleHost host = this.getHost();
        if (host != null) {
            host.HandleRuleUpdate(type, updateMessage);
        }
        if (this.menu.isClient()) {
            CompoundTag message = new CompoundTag();
            message.m_128359_("TradeRuleEdit", type.toString());
            message.m_128365_("UpdateMessage", (Tag)updateMessage);
            this.menu.sendMessage(message);
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("TradeRuleEdit")) {
            ResourceLocation type = new ResourceLocation(message.m_128461_("TradeRuleEdit"));
            CompoundTag updateMessage = message.m_128469_("UpdateMessage");
            this.EditTradeRule(type, updateMessage);
        }
    }

    public static class Trade
    extends TradeRulesTab {
        private int tradeIndex = -1;

        public int getTradeIndex() {
            return this.tradeIndex;
        }

        public Trade(TraderStorageMenu menu) {
            super(menu);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Object createClientTab(Object screen) {
            return new TradeRulesClientTab.Trade(screen, this);
        }

        @Override
        public boolean canOpen(Player player) {
            return super.canOpen(player) && this.menu.hasPermission("editTrades");
        }

        @Override
        @Nullable
        public ITradeRuleHost getHost() {
            TraderData trader = this.menu.getTrader();
            if (trader != null) {
                return trader.getTrade(this.tradeIndex);
            }
            return null;
        }

        @Override
        public void receiveMessage(CompoundTag message) {
            super.receiveMessage(message);
            if (message.m_128441_("TradeIndex")) {
                this.tradeIndex = message.m_128451_("TradeIndex");
            }
        }
    }

    public static class Trader
    extends TradeRulesTab {
        public Trader(TraderStorageMenu menu) {
            super(menu);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Object createClientTab(Object screen) {
            return new TradeRulesClientTab.Trader(screen, this);
        }

        @Override
        @Nullable
        public ITradeRuleHost getHost() {
            return this.menu.getTrader();
        }
    }
}

