/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachineEntryClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SlotMachineEntryTab
extends TraderStorageTab {
    public SlotMachineEntryTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new SlotMachineEntryClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void AddEntry() {
        if (!this.menu.hasPermission("editTrades")) {
            return;
        }
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.addEntry();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("AddEntry", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void RemoveEntry(int entryIndex) {
        if (!this.menu.hasPermission("editTrades")) {
            return;
        }
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.removeEntry(entryIndex);
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("RemoveEntry", entryIndex);
                this.menu.sendMessage(message);
            }
        }
    }

    private void markEntriesDirty() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.markEntriesDirty();
        }
    }

    @Nullable
    private SlotMachineEntry getEntry(int entryIndex) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            List<SlotMachineEntry> entries = trader.getAllEntries();
            if (entryIndex < 0 || entryIndex >= entries.size()) {
                return null;
            }
            return entries.get(entryIndex);
        }
        return null;
    }

    public void AddEntryItem(int entryIndex, ItemStack item) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            entry.TryAddItem(item);
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("EditEntry", entryIndex);
                message.m_128365_("AddItem", (Tag)item.m_41739_(new CompoundTag()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void EditEntryItem(int entryIndex, int itemIndex, ItemStack item) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        if (item.m_41619_()) {
            this.RemoveEntryItem(entryIndex, itemIndex);
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            if (itemIndex < 0 || itemIndex >= entry.items.size()) {
                return;
            }
            entry.items.set(itemIndex, item);
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("EditEntry", entryIndex);
                message.m_128405_("ItemIndex", itemIndex);
                message.m_128365_("EditItem", (Tag)item.m_41739_(new CompoundTag()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void RemoveEntryItem(int entryIndex, int itemIndex) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            if (itemIndex < 0 || itemIndex >= entry.items.size()) {
                return;
            }
            entry.items.remove(itemIndex);
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("EditEntry", entryIndex);
                message.m_128405_("RemoveItem", itemIndex);
                this.menu.sendMessage(message);
            }
        }
    }

    public void ChangeEntryWeight(int entryIndex, int newWeight) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            entry.setWeight(newWeight);
            this.markEntriesDirty();
            LightmansCurrency.LogDebug("Changed entry[" + entryIndex + "]'s weight on the " + DebugUtil.getSideText(this.menu) + "!");
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("EditEntry", entryIndex);
                message.m_128405_("SetWeight", newWeight);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("AddEntry")) {
            this.AddEntry();
        }
        if (message.m_128441_("RemoveEntry")) {
            this.RemoveEntry(message.m_128451_("RemoveEntry"));
        }
        if (message.m_128441_("EditEntry")) {
            int entryIndex = message.m_128451_("EditEntry");
            if (message.m_128441_("AddItem")) {
                this.AddEntryItem(entryIndex, ItemStack.m_41712_((CompoundTag)message.m_128469_("AddItem")));
            } else if (message.m_128441_("EditItem") && message.m_128441_("ItemIndex")) {
                this.EditEntryItem(entryIndex, message.m_128451_("ItemIndex"), ItemStack.m_41712_((CompoundTag)message.m_128469_("EditItem")));
            } else if (message.m_128441_("RemoveItem")) {
                this.RemoveEntryItem(entryIndex, message.m_128451_("RemoveItem"));
            } else if (message.m_128441_("SetWeight")) {
                this.ChangeEntryWeight(entryIndex, message.m_128451_("SetWeight"));
            }
        }
    }
}

