/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate.PaygateTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaygateTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public PaygateTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new PaygateTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.hasPermission("editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public PaygateTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (this.tradeIndex >= paygate.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return paygate.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setPrice(CoinValue price) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128365_("NewPrice", (Tag)price.save());
                this.menu.sendMessage(message);
            }
        }
    }

    public void setTicket(ItemStack ticket) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTicket(ticket);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("NewTicket", true);
                if (ticket != null) {
                    message.m_128365_("Ticket", (Tag)ticket.m_41739_(new CompoundTag()));
                }
                this.menu.sendMessage(message);
            }
        }
    }

    public void setDuration(int duration) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDuration(duration);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("NewDuration", duration);
                this.menu.sendMessage(message);
            }
        }
    }

    public void setTicketStubHandling(boolean storeTicketStubs) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setStoreTicketStubs(storeTicketStubs);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("StoreTicketStubs", storeTicketStubs);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            this.tradeIndex = message.m_128451_("TradeIndex");
        } else if (message.m_128441_("NewPrice")) {
            this.setPrice(CoinValue.load(message.m_128469_("NewPrice")));
        } else if (message.m_128441_("NewTicket")) {
            ItemStack ticket = ItemStack.f_41583_;
            if (message.m_128441_("Ticket")) {
                ticket = ItemStack.m_41712_((CompoundTag)message.m_128469_("Ticket"));
            }
            this.setTicket(ticket);
        } else if (message.m_128441_("NewDuration")) {
            this.setDuration(message.m_128451_("NewDuration"));
        } else if (message.m_128441_("StoreTicketStubs")) {
            this.setTicketStubHandling(message.m_128471_("StoreTicketStubs"));
        }
    }
}

