/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item.ItemStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStorageTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();

    public ItemStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new ItemStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<? extends Slot> getSlots() {
        return this.slots;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        ItemTraderData trader;
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData && !(trader = (ItemTraderData)traderData).isPersistent()) {
            for (int i = 0; i < trader.getUpgrades().m_6643_(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, trader);
                upgradeSlot.active = false;
                addSlot.apply(upgradeSlot);
                this.slots.add(upgradeSlot);
            }
        }
    }

    @Override
    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
    }

    @Override
    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
    }

    @Override
    public boolean quickMoveStack(ItemStack stack) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return false;
            }
            TraderItemStorage storage = trader.getStorage();
            if (storage.getFittableAmount(stack) > 0) {
                storage.tryAddItem(stack);
                trader.markStorageDirty();
                return true;
            }
        }
        return super.quickMoveStack(stack);
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            ItemStack heldItem = this.menu.m_142621_();
            if (heldItem.m_41619_()) {
                List<ItemStack> storageContents = storage.getContents();
                if (storageSlot >= 0 && storageSlot < storageContents.size()) {
                    int removedAmount;
                    ItemStack stackToRemove = storageContents.get(storageSlot).m_41777_();
                    ItemStack removeStack = stackToRemove.m_41777_();
                    int tempAmount = Math.min(stackToRemove.m_41741_(), stackToRemove.m_41613_());
                    stackToRemove.m_41764_(tempAmount);
                    if (!leftClick) {
                        if (tempAmount > 1) {
                            tempAmount /= 2;
                        }
                        stackToRemove.m_41764_(tempAmount);
                    }
                    if (isShiftHeld) {
                        this.menu.player.m_150109_().m_36054_(stackToRemove);
                        removedAmount = tempAmount - stackToRemove.m_41613_();
                    } else {
                        this.menu.m_142503_(stackToRemove);
                        removedAmount = tempAmount;
                    }
                    if (removedAmount > 0) {
                        removeStack.m_41764_(removedAmount);
                        storage.removeItem(removeStack);
                        trader.markStorageDirty();
                    }
                }
            } else if (leftClick) {
                storage.tryAddItem(heldItem);
                trader.markStorageDirty();
            } else {
                ItemStack addItem = heldItem.m_41777_();
                addItem.m_41764_(1);
                if (storage.addItem(addItem)) {
                    heldItem.m_41774_(1);
                    if (heldItem.m_41619_()) {
                        this.menu.m_142503_(ItemStack.f_41583_);
                    }
                }
                trader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                this.sendStorageClickMessage(storageSlot, isShiftHeld, leftClick);
            }
        }
    }

    private void sendStorageClickMessage(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        CompoundTag message = new CompoundTag();
        message.m_128405_("ClickedSlot", storageSlot);
        message.m_128379_("HeldShift", isShiftHeld);
        message.m_128379_("LeftClick", leftClick);
        this.menu.sendMessage(message);
    }

    public void quickTransfer(int type) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            Inventory inv = this.menu.player.m_150109_();
            boolean changed = false;
            if (type == 0) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack stack = inv.m_8020_(i);
                    int fillAmount = storage.getFittableAmount(stack);
                    if (fillAmount <= 0) continue;
                    ItemStack fillStack = inv.m_7407_(i, fillAmount);
                    storage.forceAddItem(fillStack);
                }
            } else if (type == 1) {
                List<ItemStack> itemList = InventoryUtil.copyList(storage.getContents());
                for (ItemStack stack : itemList) {
                    boolean keepTrying = true;
                    while (storage.getItemCount(stack) > 0 && keepTrying) {
                        ItemStack transferStack = stack.m_41777_();
                        int transferCount = Math.min(storage.getItemCount(stack), stack.m_41741_());
                        transferStack.m_41764_(transferCount);
                        int removedCount = InventoryUtil.safeGiveToPlayer(inv, transferStack);
                        if (removedCount > 0) {
                            changed = true;
                            ItemStack removeStack = stack.m_41777_();
                            removeStack.m_41764_(removedCount);
                            storage.removeItem(removeStack);
                            continue;
                        }
                        keepTrying = false;
                    }
                }
            }
            if (changed) {
                trader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128405_("QuickTransfer", type);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("ClickedSlot", 3)) {
            int storageSlot = message.m_128451_("ClickedSlot");
            boolean isShiftHeld = message.m_128471_("HeldShift");
            boolean leftClick = message.m_128471_("LeftClick");
            this.clickedOnSlot(storageSlot, isShiftHeld, leftClick);
        }
        if (message.m_128441_("QuickTransfer")) {
            this.quickTransfer(message.m_128451_("QuickTransfer"));
        }
    }
}

