/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionCreateClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AuctionCreateTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();
    SimpleContainer auctionItems = new SimpleContainer(2);

    public AuctionCreateTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new AuctionCreateClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    public List<SimpleSlot> getSlots() {
        return this.slots;
    }

    public SimpleContainer getAuctionItems() {
        return this.auctionItems;
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
        for (int i = 0; i < this.auctionItems.m_6643_(); ++i) {
            SimpleSlot newSlot = new SimpleSlot((Container)this.auctionItems, i, 23 + i * 18, 122);
            addSlot.apply(newSlot);
            this.slots.add(newSlot);
        }
        SimpleSlot.SetActive(this.slots, false);
    }

    @Override
    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
        for (SimpleSlot slot : this.slots) {
            slot.locked = false;
        }
    }

    @Override
    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
        this.menu.clearContainer((Container)this.auctionItems);
    }

    @Override
    public void onMenuClose() {
        this.menu.clearContainer((Container)this.auctionItems);
    }

    public void createAuction(AuctionTradeData trade) {
        TraderData t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128365_("CreateAuction", (Tag)trade.getAsNBT());
                this.menu.sendMessage(message);
                return;
            }
            trade.setAuctionItems((Container)this.auctionItems);
            if (!trade.isValid()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("AuctionCreated", false);
                this.menu.sendMessage(message);
                return;
            }
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            trader.addTrade(trade, false);
            this.auctionItems.m_6211_();
            CompoundTag message = new CompoundTag();
            message.m_128379_("AuctionCreated", true);
            this.menu.sendMessage(message);
            for (SimpleSlot slot : this.slots) {
                slot.locked = true;
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("CreateAuction")) {
            this.createAuction(new AuctionTradeData(message.m_128469_("CreateAuction")));
        }
    }
}

