/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TaxInfoClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class TaxInfoTab
extends TraderStorageTab {
    public TaxInfoTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    public Object createClientTab(Object screen) {
        return new TaxInfoClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.hasPermission("editSettings");
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void AcceptTaxes(long taxCollector) {
        TraderData trader = this.menu.getTrader();
        if (trader != null && trader.hasPermission(this.menu.player, "editSettings")) {
            TaxEntry entry = TaxSaveData.GetTaxEntry(taxCollector, this.menu.isClient());
            if (entry != null && entry.IsInArea(trader)) {
                entry.acceptTaxes(trader);
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128356_("AcceptTaxCollector", taxCollector);
                this.menu.sendMessage(message);
            }
        }
    }

    public void ForceIgnoreTaxCollector(long taxCollector) {
        TraderData trader = this.menu.getTrader();
        if (trader != null) {
            TaxEntry entry = TaxSaveData.GetTaxEntry(taxCollector, this.menu.isClient());
            if (entry != null && entry.IsInArea(trader)) {
                trader.FlagTaxEntryToIgnore(entry, this.menu.player);
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128356_("ForceIgnoreTaxCollector", taxCollector);
                this.menu.sendMessage(message);
            }
        }
    }

    public void PardonIgnoredTaxCollector(long taxCollector) {
        TraderData trader = this.menu.getTrader();
        if (trader != null && trader.hasPermission(this.menu.player, "editSettings")) {
            TaxEntry entry = TaxSaveData.GetTaxEntry(taxCollector, this.menu.isClient());
            if (entry != null && entry.IsInArea(trader)) {
                trader.PardonTaxEntry(entry);
            }
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128356_("PardonTaxCollector", taxCollector);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128441_("AcceptTaxCollector")) {
            this.AcceptTaxes(message.m_128454_("AcceptTaxCollector"));
        }
        if (message.m_128441_("ForceIgnoreTaxCollector")) {
            this.ForceIgnoreTaxCollector(message.m_128454_("ForceIgnoreTaxCollector"));
        }
        if (message.m_128441_("PardonTaxCollector")) {
            this.PardonIgnoredTaxCollector(message.m_128454_("PardonTaxCollector"));
        }
    }
}

