/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slots.easy;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EasySlot
extends Slot {
    public static final ResourceLocation EMPTY_SLOT_BG = new ResourceLocation("lightmanscurrency", "item/empty_item_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_BG);
    public boolean active = true;
    public boolean locked = false;

    public EasySlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean m_6659_() {
        return this.active;
    }

    public boolean m_5857_(@NotNull ItemStack stack) {
        if (this.locked) {
            return false;
        }
        return super.m_5857_(stack);
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        if (this.locked) {
            return ItemStack.f_41583_;
        }
        return super.m_6201_(amount);
    }

    public boolean m_8010_(@NotNull Player player) {
        if (this.locked) {
            return false;
        }
        return super.m_8010_(player);
    }

    public static void SetActive(AbstractContainerMenu menu) {
        EasySlot.SetActive(menu, slot -> true);
    }

    public static void SetActive(AbstractContainerMenu menu, Function<EasySlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            EasySlot simpleSlot;
            if (slot instanceof EasySlot && ((Boolean)filter.apply(simpleSlot = (EasySlot)((Object)slot))).booleanValue()) {
                simpleSlot.active = true;
            }
        });
    }

    public static void SetInactive(AbstractContainerMenu menu) {
        EasySlot.SetInactive(menu, slot -> true);
    }

    public static void SetInactive(AbstractContainerMenu menu, Function<EasySlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            EasySlot simpleSlot;
            if (slot instanceof EasySlot && ((Boolean)filter.apply(simpleSlot = (EasySlot)((Object)slot))).booleanValue()) {
                simpleSlot.active = false;
            }
        });
    }

    public static void SetActive(List<? extends EasySlot> slots) {
        EasySlot.SetActive(slots, true);
    }

    public static void SetInactive(List<? extends EasySlot> slots) {
        EasySlot.SetActive(slots, false);
    }

    public static void SetActive(List<? extends EasySlot> slots, boolean active) {
        for (EasySlot easySlot : slots) {
            easySlot.active = active;
        }
    }

    public static void SetLocked(AbstractContainerMenu menu, boolean locked) {
        EasySlot.SetLocked(menu, locked, slot -> true);
    }

    public static void SetLocked(AbstractContainerMenu menu, boolean locked, Function<EasySlot, Boolean> filter) {
        menu.f_38839_.forEach(slot -> {
            EasySlot simpleSlot;
            if (slot instanceof EasySlot && ((Boolean)filter.apply(simpleSlot = (EasySlot)((Object)slot))).booleanValue()) {
                simpleSlot.locked = locked;
            }
        });
    }

    public static void Lock(AbstractContainerMenu menu) {
        EasySlot.SetLocked(menu, true);
    }

    public static void Lock(AbstractContainerMenu menu, Function<EasySlot, Boolean> filter) {
        EasySlot.SetLocked(menu, true, filter);
    }

    public static void Unlock(AbstractContainerMenu menu) {
        EasySlot.SetLocked(menu, false);
    }

    public static void Unlock(AbstractContainerMenu menu, Function<EasySlot, Boolean> filter) {
        EasySlot.SetLocked(menu, false, filter);
    }
}

