/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slots;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WalletSlot
extends Slot {
    public static final ResourceLocation EMPTY_WALLET_SLOT = new ResourceLocation("lightmanscurrency", "item/empty_wallet_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_WALLET_SLOT);
    private final List<IWalletSlotListener> listeners = Lists.newArrayList();
    Container blacklistInventory;
    int blacklistIndex;

    public WalletSlot(Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
    }

    public WalletSlot addListener(IWalletSlotListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public boolean m_5857_(ItemStack stack) {
        if (this.blacklistIndex >= 0 && this.blacklistInventory != null && stack == this.getBlacklistedItem()) {
            return false;
        }
        return WalletSlot.isValidWallet(stack);
    }

    public static boolean isValidWallet(ItemStack stack) {
        return stack.m_41720_() instanceof WalletItem && !stack.m_41619_();
    }

    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return BACKGROUND;
    }

    public void m_6654_() {
        super.m_6654_();
        this.listeners.forEach(listener -> listener.onWalletSlotChanged());
    }

    public void setBlacklist(Container blacklistInventory, int blacklistIndex) {
        this.blacklistInventory = blacklistInventory;
        this.blacklistIndex = blacklistIndex;
    }

    public ItemStack getBlacklistedItem() {
        return this.blacklistInventory.m_8020_(this.blacklistIndex);
    }

    public static interface IWalletSlotListener {
        public void onWalletSlotChanged();
    }
}

